/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.libs.SCMBasedRetriever;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class SCMSourceRetriever
extends SCMBasedRetriever {
    private final SCMSource scm;

    @DataBoundConstructor
    public SCMSourceRetriever(SCMSource scm) {
        this.scm = scm;
    }

    public SCMSource getScm() {
        return this.scm;
    }

    @Override
    public void retrieve(String name, String version, boolean changelog, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
        SCMRevision revision = SCMSourceRetriever.retrySCMOperation(listener, () -> this.scm.fetch(version, listener, (Item)run.getParent()));
        if (revision == null) {
            throw new AbortException("No version " + version + " found for library " + name);
        }
        this.doRetrieve(name, changelog, this.scm.build(revision.getHead(), revision), target, run, listener);
    }

    @Override
    public void retrieve(String name, String version, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
        this.retrieve(name, version, true, target, run, listener);
    }

    @Override
    public FormValidation validateVersion(String name, String version, Item context) {
        StringWriter w = new StringWriter();
        try {
            StreamTaskListener listener = new StreamTaskListener((Writer)w);
            SCMRevision revision = this.scm.fetch(version, (TaskListener)listener, context);
            if (revision != null) {
                return FormValidation.ok((String)("Currently maps to revision: " + String.valueOf(revision)));
            }
            listener.getLogger().flush();
            return FormValidation.warning((String)("Revision seems invalid:\n" + String.valueOf(w)));
        }
        catch (Exception x) {
            return FormValidation.warning((Throwable)x, (String)"Cannot validate default version.");
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class Hider
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return !((DescriptorImpl)descriptor).getSCMDescriptors().isEmpty();
            }
            return true;
        }
    }

    @Symbol(value={"modernSCM"})
    @Extension
    public static class DescriptorImpl
    extends SCMBasedRetriever.SCMBasedRetrieverDescriptor
    implements CustomDescribableModel {
        public String getDisplayName() {
            return "Modern SCM";
        }

        @Restricted(value={NoExternalUse.class})
        public Collection<SCMSourceDescriptor> getSCMDescriptors() {
            ArrayList<SCMSourceDescriptor> descriptors = new ArrayList<SCMSourceDescriptor>();
            for (SCMSourceDescriptor d : ExtensionList.lookup(SCMSourceDescriptor.class)) {
                if (!Util.isOverridden(SCMSource.class, (Class)d.clazz, (String)"retrieve", (Class[])new Class[]{String.class, TaskListener.class}) && !Util.isOverridden(SCMSource.class, (Class)d.clazz, (String)"retrieve", (Class[])new Class[]{String.class, TaskListener.class, Item.class})) continue;
                descriptors.add(d);
            }
            return descriptors;
        }

        public UninstantiatedDescribable customUninstantiate(UninstantiatedDescribable ud) {
            Object scm = ud.getArguments().get("scm");
            if (scm instanceof UninstantiatedDescribable) {
                UninstantiatedDescribable scmUd = (UninstantiatedDescribable)scm;
                LinkedHashMap scmArguments = new LinkedHashMap(scmUd.getArguments());
                scmArguments.remove("id");
                LinkedHashMap<String, UninstantiatedDescribable> retrieverArguments = new LinkedHashMap<String, UninstantiatedDescribable>(ud.getArguments());
                retrieverArguments.put("scm", scmUd.withArguments(scmArguments));
                return ud.withArguments(retrieverArguments);
            }
            return ud;
        }
    }
}

