/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.util.QualityGateStatus;
import io.jenkins.plugins.util.ResultHandler;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class PipelineResultHandler
implements ResultHandler {
    private final Run<?, ?> run;
    private final FlowNode flowNode;

    public PipelineResultHandler(Run<?, ?> run, FlowNode flowNode) {
        this.run = run;
        this.flowNode = flowNode;
    }

    @Override
    public void publishResult(Result result, String message) {
        this.run.setResult(result);
        this.setStageResult(result, message);
    }

    private void setStageResult(Result result, String message) {
        WarningAction existing = (WarningAction)this.flowNode.getPersistentAction(WarningAction.class);
        if (existing == null || existing.getResult().isBetterThan(result)) {
            this.flowNode.addOrReplaceAction((Action)new WarningAction(result).withMessage(message));
        }
    }

    @Override
    public void publishResult(QualityGateStatus status, String message) {
        switch (status) {
            case NOTE: 
            case ERROR: {
                this.setStageResult(status.getResult(), message);
                break;
            }
            case WARNING: 
            case FAILED: {
                this.publishResult(status.getResult(), message);
                break;
            }
        }
    }
}

