/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ClaimSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodResourceClaim references exactly one ResourceClaim through a ClaimSource. It adds a name to it that uniquely identifies the ResourceClaim inside the Pod. Containers that need access to the ResourceClaim reference it with this name.")
public class V1PodResourceClaim {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private V1ClaimSource source;

    public V1PodResourceClaim name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1PodResourceClaim source(V1ClaimSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ClaimSource getSource() {
        return this.source;
    }

    public void setSource(V1ClaimSource source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodResourceClaim v1PodResourceClaim = (V1PodResourceClaim)o;
        return Objects.equals(this.name, v1PodResourceClaim.name) && Objects.equals(this.source, v1PodResourceClaim.source);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodResourceClaim {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

