/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxDistinct;
import io.micrometer.shaded.reactor.core.publisher.InternalFluxOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

final class FluxDistinctFuseable<T, K, C>
extends InternalFluxOperator<T, T>
implements Fuseable {
    final Function<? super T, ? extends K> keyExtractor;
    final Supplier<C> collectionSupplier;
    final BiPredicate<C, K> distinctPredicate;
    final Consumer<C> cleanupCallback;

    FluxDistinctFuseable(Flux<? extends T> source, Function<? super T, ? extends K> keyExtractor, Supplier<C> collectionSupplier, BiPredicate<C, K> distinctPredicate, Consumer<C> cleanupCallback) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier, "collectionSupplier");
        this.distinctPredicate = Objects.requireNonNull(distinctPredicate, "distinctPredicate");
        this.cleanupCallback = Objects.requireNonNull(cleanupCallback, "cleanupCallback");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        C collection;
        try {
            collection = Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return null;
        }
        return new FluxDistinct.DistinctFuseableSubscriber<T, K, C>(actual, collection, this.keyExtractor, this.distinctPredicate, this.cleanupCallback);
    }
}

