/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CorePublisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.ConnectableFlux;
import io.micrometer.shaded.reactor.core.publisher.OptimizableOperator;
import io.micrometer.shaded.reactor.util.annotation.Nullable;

abstract class InternalConnectableFluxOperator<I, O>
extends ConnectableFlux<O>
implements Scannable,
OptimizableOperator<O, I> {
    final ConnectableFlux<I> source;
    @Nullable
    final OptimizableOperator<?, I> optimizableOperator;

    public InternalConnectableFluxOperator(ConnectableFlux<I> source) {
        this.source = source;
        this.optimizableOperator = source instanceof OptimizableOperator ? (OptimizableOperator)((Object)source) : null;
    }

    @Override
    public final void subscribe(CoreSubscriber<? super O> subscriber) {
        OptimizableOperator<Object, Object> operator = this;
        while ((subscriber = operator.subscribeOrReturn(subscriber)) != null) {
            OptimizableOperator newSource = operator.nextOptimizableSource();
            if (newSource == null) {
                operator.source().subscribe(subscriber);
                return;
            }
            operator = newSource;
        }
        return;
    }

    @Override
    @Nullable
    public abstract CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super O> var1);

    @Override
    public final CorePublisher<? extends I> source() {
        return this.source;
    }

    @Override
    public final OptimizableOperator<?, ? extends I> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }
}

