/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CorePublisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoNext;
import io.micrometer.shaded.reactor.core.publisher.OptimizableOperator;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;

final class MonoFromPublisher<T>
extends Mono<T>
implements Scannable,
OptimizableOperator<T, T> {
    final Publisher<? extends T> source;
    @Nullable
    final OptimizableOperator<?, T> optimizableOperator;

    MonoFromPublisher(Publisher<? extends T> source) {
        this.source = Objects.requireNonNull(source, "publisher");
        this.optimizableOperator = source instanceof OptimizableOperator ? (OptimizableOperator)source : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        CoreSubscriber<? super T> subscriber = this.subscribeOrReturn(actual);
        if (subscriber == null) {
            return;
        }
        this.source.subscribe(subscriber);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MonoNext.NextSubscriber<T>(actual);
    }

    @Override
    public final CorePublisher<? extends T> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends T> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }
}

