/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.FluxContextStart;
import io.micrometer.shaded.reactor.core.publisher.InternalMonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Objects;
import java.util.function.Function;

final class MonoSubscriberContext<T>
extends InternalMonoOperator<T, T>
implements Fuseable {
    final Function<Context, Context> doOnContext;

    MonoSubscriberContext(Mono<? extends T> source, Function<Context, Context> doOnContext) {
        super(source);
        this.doOnContext = Objects.requireNonNull(doOnContext, "doOnContext");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        Context c;
        try {
            c = this.doOnContext.apply(actual.currentContext());
        }
        catch (Throwable t) {
            Operators.error(actual, Operators.onOperatorError(t, actual.currentContext()));
            return null;
        }
        return new FluxContextStart.ContextStartSubscriber<T>(actual, c);
    }
}

