/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.util.context.Context;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class FutureMono
extends Mono<Void> {
    public static <F extends Future<Void>> Mono<Void> from(F future) {
        if (future.isDone()) {
            if (!future.isSuccess()) {
                return Mono.error(future.cause());
            }
            return Mono.empty();
        }
        return new ImmediateFutureMono<F>(future);
    }

    public static <F extends Future<Void>> Mono<Void> deferFuture(Supplier<F> deferredFuture) {
        return new DeferredFutureMono<F>(deferredFuture);
    }

    static final class FutureSubscription<F extends Future<Void>>
    implements GenericFutureListener<F>,
    Subscription,
    Supplier<Context> {
        final CoreSubscriber<? super Void> s;
        final F future;

        FutureSubscription(F future, CoreSubscriber<? super Void> s) {
            this.s = s;
            this.future = future;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public Context get() {
            return this.s.currentContext();
        }

        @Override
        public void cancel() {
            this.future.removeListener(this);
        }

        @Override
        public void operationComplete(F future) {
            if (!future.isSuccess()) {
                if (future.cause() instanceof ClosedChannelException) {
                    this.s.onError(ReactorNetty.wrapException(future.cause()));
                } else {
                    this.s.onError(future.cause());
                }
            } else {
                this.s.onComplete();
            }
        }
    }

    static final class DeferredFutureMono<F extends Future<Void>>
    extends FutureMono {
        final Supplier<F> deferredFuture;

        DeferredFutureMono(Supplier<F> deferredFuture) {
            this.deferredFuture = Objects.requireNonNull(deferredFuture, "deferredFuture");
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            Future f;
            try {
                f = (Future)this.deferredFuture.get();
            }
            catch (Throwable t) {
                Operators.error(s, t);
                return;
            }
            if (f == null) {
                Operators.error(s, Operators.onOperatorError(new NullPointerException("Deferred supplied null"), s.currentContext()));
                return;
            }
            if (f.isDone()) {
                if (f.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, f.cause());
                }
                return;
            }
            FutureSubscription<Future> fs = new FutureSubscription<Future>(f, s);
            s.onSubscribe(fs);
            f.addListener(fs);
        }
    }

    static final class ImmediateFutureMono<F extends Future<Void>>
    extends FutureMono {
        final F future;

        ImmediateFutureMono(F future) {
            this.future = (Future)Objects.requireNonNull(future, "future");
        }

        @Override
        public final void subscribe(CoreSubscriber<? super Void> s) {
            if (this.future.isDone()) {
                if (this.future.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, this.future.cause());
                }
                return;
            }
            FutureSubscription<F> fs = new FutureSubscription<F>(this.future, s);
            this.future.addListener(fs);
            s.onSubscribe(fs);
        }
    }
}

