/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.DatagramPacket;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import java.net.SocketAddress;
import java.time.Duration;
import javax.annotation.Nullable;

public class ChannelMetricsHandler
extends ChannelDuplexHandler {
    final ChannelMetricsRecorder recorder;
    final SocketAddress remoteAddress;
    final boolean onServer;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        this.recorder = recorder;
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (!this.onServer) {
            ctx.pipeline().addAfter("io.micrometer.shaded.reactor.left.channelMetricsHandler", "io.micrometer.shaded.reactor.left.connectMetricsHandler", new ConnectMetricsHandler(this.recorder));
        }
        if (ctx.pipeline().get(SslHandler.class) != null) {
            ctx.pipeline().addAfter("io.micrometer.shaded.reactor.left.sslHandler", "io.micrometer.shaded.reactor.left.sslMetricsHandler", new TlsMetricsHandler(this.recorder, this.remoteAddress));
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recorder.recordDataReceived(this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            if (this.remoteAddress != null) {
                this.recorder.recordDataReceived(this.remoteAddress, buffer.readableBytes());
            } else {
                this.recorder.recordDataReceived((SocketAddress)p.sender(), buffer.readableBytes());
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recorder.recordDataSent(this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            if (this.remoteAddress != null) {
                this.recorder.recordDataSent(this.remoteAddress, buffer.readableBytes());
            } else {
                this.recorder.recordDataSent((SocketAddress)p.recipient(), buffer.readableBytes());
            }
        }
        ctx.write(msg, promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.remoteAddress != null) {
            this.recorder.incrementErrorsCount(this.remoteAddress);
        } else {
            this.recorder.incrementErrorsCount(ctx.channel().remoteAddress());
        }
        ctx.fireExceptionCaught(cause);
    }

    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.currentTimeMillis();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ctx.pipeline().remove(this);
                String status = future.isSuccess() ? "SUCCESS" : "ERROR";
                this.recorder.recordConnectTime(remoteAddress, Duration.ofMillis(System.currentTimeMillis() - connectTimeStart), status);
            }));
        }
    }

    static final class TlsMetricsHandler
    extends ChannelInboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;
        final SocketAddress remoteAddress;
        final long tlsHandshakeTimeStart;

        TlsMetricsHandler(ChannelMetricsRecorder recorder, SocketAddress remoteAddress) {
            this.recorder = recorder;
            this.remoteAddress = remoteAddress;
            this.tlsHandshakeTimeStart = System.currentTimeMillis();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                ctx.pipeline().remove(this);
                SslHandshakeCompletionEvent handshake = (SslHandshakeCompletionEvent)evt;
                String status = handshake.isSuccess() ? "SUCCESS" : "ERROR";
                this.recorder.recordTlsHandshakeTime(this.remoteAddress, Duration.ofMillis(System.currentTimeMillis() - this.tlsHandshakeTimeStart), status);
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

