/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.buffer.ByteBufUtil;
import io.micrometer.shaded.io.netty.buffer.EmptyByteBuf;
import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.handler.codec.DecoderResult;
import io.micrometer.shaded.io.netty.handler.codec.DecoderResultProvider;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;

final class ChannelOperationsHandler
extends ChannelInboundHandlerAdapter {
    final ConnectionObserver listener;
    final ChannelOperations.OnSetup opsFactory;
    static final Logger log = Loggers.getLogger(ChannelOperationsHandler.class);

    ChannelOperationsHandler(ChannelOperations.OnSetup opsFactory, ConnectionObserver listener) {
        this.listener = listener;
        this.opsFactory = opsFactory;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        Connection c = Connection.from(ctx.channel());
        this.listener.onStateChange(c, ConnectionObserver.State.CONNECTED);
        ChannelOperations<?, ?> ops = this.opsFactory.create(c, this.listener, null);
        if (ops != null) {
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        }
    }

    @Override
    public final void channelInactive(ChannelHandlerContext ctx) {
        try {
            Connection connection = Connection.from(ctx.channel());
            ChannelOperations ops = connection.as(ChannelOperations.class);
            if (ops != null) {
                ops.onInboundClose();
            } else {
                this.listener.onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
            }
        }
        catch (Throwable err) {
            this.exceptionCaught(ctx, err);
        }
    }

    @Override
    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg == null || msg == Unpooled.EMPTY_BUFFER || msg instanceof EmptyByteBuf) {
            return;
        }
        try {
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            if (ops != null) {
                ops.onInboundNext(ctx, msg);
            } else {
                if (log.isDebugEnabled()) {
                    String loggingMsg;
                    DecoderResult decoderResult;
                    if (msg instanceof DecoderResultProvider && (decoderResult = ((DecoderResultProvider)msg).decoderResult()).isFailure()) {
                        log.debug(ReactorNetty.format(ctx.channel(), "Decoding failed: " + msg + " : "), decoderResult.cause());
                    }
                    if (msg instanceof ByteBufHolder && ((ByteBufHolder)msg).content() != Unpooled.EMPTY_BUFFER) {
                        ByteBuf buffer = ((ByteBufHolder)msg).content();
                        loggingMsg = "\n" + ByteBufUtil.prettyHexDump(buffer);
                    } else {
                        loggingMsg = msg instanceof ByteBuf ? "\n" + ByteBufUtil.prettyHexDump((ByteBuf)msg) : msg.toString();
                    }
                    log.debug(ReactorNetty.format(ctx.channel(), "No ChannelOperation attached. Dropping: {}"), loggingMsg);
                }
                ReferenceCountUtil.release(msg);
            }
        }
        catch (Throwable err) {
            ReferenceCountUtil.safeRelease(msg);
            log.error(ReactorNetty.format(ctx.channel(), "Error was received while reading the incoming data. The connection will be closed."), err);
            ctx.close();
            this.exceptionCaught(ctx, err);
        }
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable err) {
        Connection connection = Connection.from(ctx.channel());
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            ops.onInboundError(err);
        } else {
            this.listener.onUncaughtException(connection, err);
        }
    }
}

