/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelInitializer;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpClientCodec;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpContentDecompressor;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2FrameLogger;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.micrometer.shaded.io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.micrometer.shaded.io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.micrometer.shaded.io.netty.util.AsciiString;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.DirectProcessor;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.AbortedException;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.http.HttpResources;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientMetricsHandler;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientMetricsRecorder;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientSecure;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientState;
import io.micrometer.shaded.reactor.netty.http.client.HttpResponseDecoderSpec;
import io.micrometer.shaded.reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import io.micrometer.shaded.reactor.netty.http.client.RedirectClientException;
import io.micrometer.shaded.reactor.netty.http.client.UriEndpoint;
import io.micrometer.shaded.reactor.netty.http.client.UriEndpointFactory;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.InetSocketAddressUtil;
import io.micrometer.shaded.reactor.netty.tcp.ProxyProvider;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.context.Context;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class HttpClientConnect
extends HttpClient {
    final HttpTcpClient defaultClient;
    static final HttpClientConnect INSTANCE = new HttpClientConnect();
    static final AsciiString ALL = new AsciiString("*/*");
    static final Logger log = Loggers.getLogger(HttpClientConnect.class);
    static final BiFunction<String, Integer, InetSocketAddress> URI_ADDRESS_MAPPER = InetSocketAddressUtil::createUnresolved;

    HttpClientConnect() {
        this(DEFAULT_TCP_CLIENT);
    }

    HttpClientConnect(TcpClient defaultClient) {
        Objects.requireNonNull(defaultClient, "tcpClient");
        this.defaultClient = new HttpTcpClient(defaultClient);
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.defaultClient;
    }

    static void openStream(Channel ch, final ConnectionObserver listener, final HttpClientInitializer initializer) {
        Http2StreamChannelBootstrap http2StreamChannelBootstrap = new Http2StreamChannelBootstrap(ch).handler(new ChannelInitializer(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new Http2StreamFrameToHttpObjectCodec(false));
                ChannelOperations.addReactiveBridge(ch, (conn, l, msg) -> new HttpClientOperations(conn, l, initializer2.handler.cookieEncoder, initializer2.handler.cookieDecoder), listener);
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(ch, "Initialized HTTP/2 pipeline {}"), ch.pipeline());
                }
                initializer.upgraded.onComplete();
            }
        });
        http2StreamChannelBootstrap.open().addListener(initializer);
    }

    static final class Http2StreamInitializer
    extends ChannelInitializer<Channel> {
        Http2StreamInitializer() {
        }

        @Override
        protected void initChannel(Channel ch) {
        }
    }

    static final class Http2ClientInitializer
    extends ApplicationProtocolNegotiationHandler {
        final HttpClientInitializer parent;
        final ConnectionObserver listener;

        Http2ClientInitializer(ConnectionObserver listener, HttpClientInitializer parent) {
            super("http/1.1");
            this.listener = listener;
            this.parent = parent;
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            ChannelPipeline p = ctx.pipeline();
            if ("h2".equals(protocol)) {
                Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forClient().validateHeaders(true).initialSettings(Http2Settings.defaultSettings());
                if (p.get("io.micrometer.shaded.reactor.left.loggingHandler") != null) {
                    http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, HttpClient.class));
                }
                p.addLast(http2FrameCodecBuilder.build()).addLast(new Http2MultiplexHandler(new Http2StreamInitializer()));
                HttpClientConnect.openStream(ctx.channel(), this.listener, this.parent);
                return;
            }
            if ("http/1.1".equals(protocol)) {
                ChannelHandler handler;
                p.addBefore("io.micrometer.shaded.reactor.right.reactiveBridge", "io.micrometer.shaded.reactor.left.httpCodec", new HttpClientCodec(this.parent.handler.decoder.maxInitialLineLength(), this.parent.handler.decoder.maxHeaderSize(), this.parent.handler.decoder.maxChunkSize(), this.parent.handler.decoder.failOnMissingResponse, this.parent.handler.decoder.validateHeaders(), this.parent.handler.decoder.initialBufferSize(), this.parent.handler.decoder.parseHttpAfterConnectRequest));
                if (this.parent.handler.compress) {
                    p.addAfter("io.micrometer.shaded.reactor.left.httpCodec", "io.micrometer.shaded.reactor.left.decompressor", new HttpContentDecompressor());
                }
                if ((handler = p.get("io.micrometer.shaded.reactor.left.channelMetricsHandler")) != null) {
                    ChannelMetricsRecorder channelMetricsRecorder = ((ChannelMetricsHandler)handler).recorder();
                    if (channelMetricsRecorder instanceof MicrometerChannelMetricsRecorder) {
                        MicrometerChannelMetricsRecorder recorder = (MicrometerChannelMetricsRecorder)channelMetricsRecorder;
                        HttpClientMetricsHandler httpMetrics = new HttpClientMetricsHandler(new MicrometerHttpClientMetricsRecorder(recorder.name(), recorder.remoteAddress(), "http"));
                        p.addLast("io.micrometer.shaded.reactor.left.httpMetricsHandler", (ChannelHandler)httpMetrics);
                    } else if (channelMetricsRecorder instanceof HttpClientMetricsRecorder) {
                        HttpClientMetricsHandler httpMetrics = new HttpClientMetricsHandler((HttpClientMetricsRecorder)channelMetricsRecorder);
                        p.addLast("io.micrometer.shaded.reactor.left.httpMetricsHandler", (ChannelHandler)httpMetrics);
                    }
                }
                this.parent.upgraded.onComplete();
                return;
            }
            this.parent.upgraded.onError(new IllegalStateException("unknown protocol: " + protocol));
        }
    }

    @ChannelHandler.Sharable
    static final class HttpClientInitializer
    extends ChannelInboundHandlerAdapter
    implements BiConsumer<ConnectionObserver, Channel>,
    ChannelOperations.OnSetup,
    GenericFutureListener<Future<Http2StreamChannel>> {
        final HttpClientHandler handler;
        final DirectProcessor<Void> upgraded;

        HttpClientInitializer(HttpClientHandler handler) {
            this.handler = handler;
            this.upgraded = DirectProcessor.create();
        }

        @Override
        public void operationComplete(Future<Http2StreamChannel> future) {
            if (!future.isSuccess()) {
                this.upgraded.onError(future.cause());
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            if (ops != null) {
                ops.listener().onStateChange(ops, ConnectionObserver.State.CONFIGURED);
            }
            ctx.fireChannelActive();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                ctx.channel().read();
                ctx.pipeline().remove(this);
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                ctx.pipeline().remove(this);
                if (this.handler.compress) {
                    ctx.pipeline().addLast("io.micrometer.shaded.reactor.left.decompressor", (ChannelHandler)new HttpContentDecompressor());
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public ChannelOperations<?, ?> create(Connection c, ConnectionObserver listener, @Nullable Object msg) {
            return new HttpClientOperations(c, listener, this.handler.cookieEncoder, this.handler.cookieDecoder);
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            ChannelPipeline p = channel.pipeline();
            if (p.get("io.micrometer.shaded.reactor.left.sslHandler") != null) {
                p.addLast(new Http2ClientInitializer(listener, this));
            } else {
                HttpClientCodec httpClientCodec = new HttpClientCodec(this.handler.decoder.maxInitialLineLength(), this.handler.decoder.maxHeaderSize(), this.handler.decoder.maxChunkSize(), this.handler.decoder.failOnMissingResponse, this.handler.decoder.validateHeaders(), this.handler.decoder.initialBufferSize(), this.handler.decoder.parseHttpAfterConnectRequest);
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                HttpToHttp2ConnectionHandlerBuilder h2HandlerBuilder = new HttpToHttp2ConnectionHandlerBuilder().frameListener(new InboundHttp2ToHttpAdapterBuilder(connection).maxContentLength(65536).propagateSettings(true).build()).connection(connection);
                if (p.get("io.micrometer.shaded.reactor.left.loggingHandler") != null) {
                    h2HandlerBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, HttpClient.class));
                }
                p.addLast("io.micrometer.shaded.reactor.left.httpCodec", (ChannelHandler)httpClientCodec);
                this.upgraded.onComplete();
            }
        }
    }

    static final class Http1Initializer
    implements BiConsumer<ConnectionObserver, Channel> {
        final HttpResponseDecoderSpec decoder;
        final boolean compress;
        final int protocols;

        Http1Initializer(HttpResponseDecoderSpec decoder, boolean compress, int protocols) {
            this.decoder = decoder;
            this.compress = compress;
            this.protocols = protocols;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            ChannelHandler handler;
            ChannelPipeline p = channel.pipeline();
            p.addLast("io.micrometer.shaded.reactor.left.httpCodec", (ChannelHandler)new HttpClientCodec(this.decoder.maxInitialLineLength(), this.decoder.maxHeaderSize(), this.decoder.maxChunkSize(), this.decoder.failOnMissingResponse, this.decoder.validateHeaders(), this.decoder.initialBufferSize(), this.decoder.parseHttpAfterConnectRequest));
            if (this.compress) {
                p.addAfter("io.micrometer.shaded.reactor.left.httpCodec", "io.micrometer.shaded.reactor.left.decompressor", new HttpContentDecompressor());
            }
            if ((handler = p.get("io.micrometer.shaded.reactor.left.channelMetricsHandler")) != null) {
                ChannelMetricsRecorder channelMetricsRecorder = ((ChannelMetricsHandler)handler).recorder();
                if (channelMetricsRecorder instanceof MicrometerChannelMetricsRecorder) {
                    MicrometerChannelMetricsRecorder recorder = (MicrometerChannelMetricsRecorder)channelMetricsRecorder;
                    HttpClientMetricsHandler httpMetrics = new HttpClientMetricsHandler(new MicrometerHttpClientMetricsRecorder(recorder.name(), recorder.remoteAddress(), "http"));
                    p.addLast("io.micrometer.shaded.reactor.left.httpMetricsHandler", (ChannelHandler)httpMetrics);
                } else if (channelMetricsRecorder instanceof HttpClientMetricsRecorder) {
                    HttpClientMetricsHandler httpMetrics = new HttpClientMetricsHandler((HttpClientMetricsRecorder)channelMetricsRecorder);
                    p.addLast("io.micrometer.shaded.reactor.left.httpMetricsHandler", (ChannelHandler)httpMetrics);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Http1Initializer that = (Http1Initializer)o;
            return this.compress == that.compress && this.protocols == that.protocols;
        }

        public int hashCode() {
            return Objects.hash(this.compress, this.protocols);
        }
    }

    static final class HttpClientHandler
    extends SocketAddress
    implements Predicate<Throwable>,
    Supplier<SocketAddress> {
        final HttpMethod method;
        final HttpHeaders defaultHeaders;
        final BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> handler;
        final boolean compress;
        final UriEndpointFactory uriEndpointFactory;
        final String websocketProtocols;
        final int maxFramePayloadLength;
        final ClientCookieEncoder cookieEncoder;
        final ClientCookieDecoder cookieDecoder;
        final BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate;
        final HttpResponseDecoderSpec decoder;
        final ProxyProvider proxyProvider;
        volatile UriEndpoint toURI;
        volatile UriEndpoint fromURI;
        volatile Supplier<String>[] redirectedFrom;
        volatile boolean retried;

        HttpClientHandler(HttpClientConfiguration configuration, @Nullable SocketAddress address, @Nullable SslProvider sslProvider, @Nullable ProxyProvider proxyProvider) {
            this.method = configuration.method;
            this.compress = configuration.acceptGzip;
            this.followRedirectPredicate = configuration.followRedirectPredicate;
            this.cookieEncoder = configuration.cookieEncoder;
            this.cookieDecoder = configuration.cookieDecoder;
            this.decoder = configuration.decoder;
            this.proxyProvider = proxyProvider;
            HttpHeaders defaultHeaders = configuration.headers;
            if (this.compress) {
                this.defaultHeaders = defaultHeaders == null ? new DefaultHttpHeaders() : defaultHeaders;
                this.defaultHeaders.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
            } else {
                this.defaultHeaders = defaultHeaders;
            }
            String baseUrl = configuration.baseUrl;
            String uri = configuration.uri;
            String string = uri = uri == null ? "/" : uri;
            if (baseUrl != null && uri.startsWith("/")) {
                if (baseUrl.endsWith("/")) {
                    baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
                }
                uri = baseUrl + uri;
            }
            Supplier<SocketAddress> addressSupplier = address instanceof Supplier ? (Supplier<SocketAddress>)((Object)address) : () -> address;
            this.uriEndpointFactory = new UriEndpointFactory(addressSupplier, sslProvider != null, URI_ADDRESS_MAPPER);
            this.websocketProtocols = configuration.websocketSubprotocols;
            this.maxFramePayloadLength = configuration.websocketMaxFramePayloadLength;
            this.handler = configuration.body;
            this.toURI = this.uriEndpointFactory.createUriEndpoint(uri, configuration.websocketSubprotocols != null);
        }

        @Override
        public SocketAddress get() {
            SocketAddress address = this.toURI.getRemoteAddress();
            if (this.proxyProvider != null && !this.proxyProvider.shouldProxy(address) && address instanceof InetSocketAddress) {
                address = InetSocketAddressUtil.replaceWithResolved((InetSocketAddress)address);
            }
            return address;
        }

        Publisher<Void> requestWithBody(HttpClientOperations ch) {
            try {
                UriEndpoint uri = this.toURI;
                HttpHeaders headers = ch.getNettyRequest().setUri(uri.getPathAndQuery()).setMethod(this.method).setProtocolVersion(HttpVersion.HTTP_1_1).headers();
                if (this.defaultHeaders != null) {
                    headers.set(this.defaultHeaders);
                }
                if (!headers.contains(HttpHeaderNames.USER_AGENT)) {
                    headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpClient.USER_AGENT);
                }
                if (this.fromURI != null && !this.toURI.equals(this.fromURI)) {
                    headers.remove(HttpHeaderNames.HOST).remove(HttpHeaderNames.EXPECT).remove(HttpHeaderNames.COOKIE).remove(HttpHeaderNames.AUTHORIZATION).remove(HttpHeaderNames.PROXY_AUTHORIZATION);
                }
                SocketAddress remoteAddress = uri.getRemoteAddress();
                if (!headers.contains(HttpHeaderNames.HOST) && remoteAddress instanceof InetSocketAddress) {
                    headers.set((CharSequence)HttpHeaderNames.HOST, (Object)HttpClientHandler.resolveHostHeaderValue((InetSocketAddress)remoteAddress));
                }
                if (!headers.contains(HttpHeaderNames.ACCEPT)) {
                    headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)ALL);
                }
                ch.followRedirectPredicate(this.followRedirectPredicate);
                if (!(Objects.equals(this.method, HttpMethod.GET) || Objects.equals(this.method, HttpMethod.HEAD) || Objects.equals(this.method, HttpMethod.DELETE) || headers.contains(HttpHeaderNames.CONTENT_LENGTH))) {
                    ch.chunkedTransfer(true);
                }
                if (this.handler != null) {
                    if (this.websocketProtocols != null) {
                        return Mono.fromRunnable(() -> ch.withWebsocketSupport(this.websocketProtocols, this.maxFramePayloadLength, this.compress)).thenEmpty(Mono.fromRunnable(() -> Flux.concat(new Publisher[]{this.handler.apply(ch, ch)})));
                    }
                    return this.handler.apply(ch, ch);
                }
                if (this.websocketProtocols != null) {
                    return Mono.fromRunnable(() -> ch.withWebsocketSupport(this.websocketProtocols, this.maxFramePayloadLength, this.compress));
                }
                return ch.send();
            }
            catch (Throwable t) {
                return Mono.error(t);
            }
        }

        static String resolveHostHeaderValue(@Nullable InetSocketAddress remoteAddress) {
            if (remoteAddress != null) {
                String host = HttpUtil.formatHostnameForHttp(remoteAddress);
                int port = remoteAddress.getPort();
                if (port != 80 && port != 443) {
                    host = host + ':' + port;
                }
                return host;
            }
            return "localhost";
        }

        void redirect(String to) {
            Supplier<String>[] redirectedFrom = this.redirectedFrom;
            UriEndpoint from = this.toURI;
            if (to.startsWith("/")) {
                SocketAddress address = from.getRemoteAddress();
                if (address instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    this.toURI = this.uriEndpointFactory.createUriEndpoint(to, from.isWs(), () -> URI_ADDRESS_MAPPER.apply(inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
                } else {
                    this.toURI = this.uriEndpointFactory.createUriEndpoint(to, from.isWs(), () -> URI_ADDRESS_MAPPER.apply(from.host, from.port));
                }
            } else {
                this.toURI = this.uriEndpointFactory.createUriEndpoint(to, from.isWs());
            }
            this.fromURI = from;
            this.redirectedFrom = HttpClientHandler.addToRedirectedFromArray(redirectedFrom, from);
        }

        static Supplier<String>[] addToRedirectedFromArray(@Nullable Supplier<String>[] redirectedFrom, UriEndpoint from) {
            Supplier<String> fromUrlSupplier = from::toExternalForm;
            if (redirectedFrom == null) {
                return new Supplier[]{fromUrlSupplier};
            }
            Supplier[] newRedirectedFrom = new Supplier[redirectedFrom.length + 1];
            System.arraycopy(redirectedFrom, 0, newRedirectedFrom, 0, redirectedFrom.length);
            newRedirectedFrom[redirectedFrom.length] = fromUrlSupplier;
            return newRedirectedFrom;
        }

        void channel(HttpClientOperations ops) {
            Supplier<String>[] redirectedFrom = this.redirectedFrom;
            if (redirectedFrom != null) {
                ops.redirectedFrom = redirectedFrom;
            }
        }

        @Override
        public boolean test(Throwable throwable) {
            if (throwable instanceof RedirectClientException) {
                RedirectClientException re = (RedirectClientException)throwable;
                this.redirect(re.location);
                return true;
            }
            if (AbortedException.isConnectionReset(throwable) && !this.retried) {
                this.retried = true;
                this.redirect(this.toURI.toString());
                return true;
            }
            return false;
        }

        public String toString() {
            return "{uri=" + this.toURI + ", method=" + this.method + '}';
        }
    }

    static final class HttpIOHandlerObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final HttpClientHandler handler;

        HttpIOHandlerObserver(MonoSink<Connection> sink, HttpClientHandler handler) {
            this.sink = sink;
            this.handler = handler;
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED && HttpClientOperations.class == connection.getClass()) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Handler is being applied: {}"), this.handler);
                }
                Mono.defer(() -> Mono.fromDirect(this.handler.requestWithBody((HttpClientOperations)connection))).subscribe(connection.disposeSubscriber());
            }
        }
    }

    static final class HttpObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final HttpClientHandler handler;

        HttpObserver(MonoSink<Connection> sink, HttpClientHandler handler) {
            this.sink = sink;
            this.handler = handler;
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            if (error instanceof RedirectClientException) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "The request will be redirected"));
                }
            } else if (AbortedException.isConnectionReset(error)) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "The connection observed an error, the request will be retried"), error);
                }
            } else if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format(connection.channel(), "The connection observed an error"), error);
            }
            this.sink.error(error);
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == HttpClientState.RESPONSE_RECEIVED) {
                this.sink.success(connection);
                return;
            }
            if (newState == ConnectionObserver.State.CONFIGURED && HttpClientOperations.class == connection.getClass()) {
                this.handler.channel((HttpClientOperations)connection);
            }
        }
    }

    static final class MonoHttpConnect
    extends Mono<Connection> {
        final Bootstrap bootstrap;
        final HttpClientConfiguration configuration;
        final TcpClient tcpClient;
        final SslProvider sslProvider;
        final ProxyProvider proxyProvider;

        MonoHttpConnect(Bootstrap bootstrap, HttpClientConfiguration configuration, TcpClient tcpClient, @Nullable SslProvider sslProvider) {
            this.bootstrap = bootstrap;
            this.configuration = configuration;
            this.sslProvider = sslProvider;
            this.tcpClient = tcpClient;
            this.proxyProvider = ProxyProvider.findProxySupport(bootstrap);
        }

        @Override
        public void subscribe(CoreSubscriber<? super Connection> actual) {
            Bootstrap b = this.bootstrap.clone();
            HttpClientHandler handler = new HttpClientHandler(this.configuration, b.config().remoteAddress(), this.sslProvider, this.proxyProvider);
            b.remoteAddress(handler);
            if (this.sslProvider != null) {
                if ((this.configuration.protocols & 1) == 1) {
                    Operators.error(actual, new IllegalArgumentException("Configured H2 Clear-Text protocol with TLS. Use the non clear-text h2 protocol via HttpClient#protocol or disable TLS via HttpClient#tcpConfiguration(tcp -> tcp.noSSL())"));
                    return;
                }
                if ((this.configuration.protocols & 4) == 4) {
                    BootstrapHandlers.updateConfiguration(b, "io.micrometer.shaded.reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new Http1Initializer(handler.decoder, handler.compress, this.configuration.protocols));
                }
            } else {
                if ((this.configuration.protocols & 2) == 2) {
                    Operators.error(actual, new IllegalArgumentException("Configured H2 protocol without TLS. Use a clear-text h2 protocol via HttpClient#protocol or configure TLS via HttpClient#secure"));
                    return;
                }
                if ((this.configuration.protocols & 4) == 4) {
                    BootstrapHandlers.updateConfiguration(b, "io.micrometer.shaded.reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new Http1Initializer(handler.decoder, handler.compress, this.configuration.protocols));
                }
            }
            Mono.create(sink -> {
                Bootstrap finalBootstrap;
                if (handler.toURI.isSecure()) {
                    if (this.sslProvider == null) {
                        if ((this.configuration.protocols & 1) == 1) {
                            sink.error(new IllegalArgumentException("Configured H2 Clear-Text protocol without TLS while trying to redirect to a secure address."));
                            return;
                        }
                        finalBootstrap = SslProvider.setBootstrap(b.clone(), HttpClientSecure.DEFAULT_HTTP_SSL_PROVIDER);
                    } else {
                        finalBootstrap = b.clone();
                    }
                } else {
                    finalBootstrap = this.sslProvider != null ? SslProvider.removeSslSupport(b.clone()) : b.clone();
                }
                BootstrapHandlers.connectionObserver(finalBootstrap, new HttpObserver((MonoSink<Connection>)sink, handler).then(BootstrapHandlers.connectionObserver(finalBootstrap)).then(new HttpIOHandlerObserver((MonoSink<Connection>)sink, handler)));
                this.tcpClient.connect(finalBootstrap).subscribe(new TcpClientSubscriber((MonoSink<Connection>)sink));
            }).retry(handler).subscribe(actual);
        }

        static final class TcpClientSubscriber
        implements CoreSubscriber<Connection> {
            final MonoSink<Connection> sink;

            TcpClientSubscriber(MonoSink<Connection> sink) {
                this.sink = sink;
            }

            @Override
            public void onSubscribe(Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(Connection connection) {
                this.sink.onCancel(connection);
            }

            @Override
            public void onError(Throwable throwable) {
                this.sink.error(throwable);
            }

            @Override
            public void onComplete() {
            }

            @Override
            public Context currentContext() {
                return this.sink.currentContext();
            }
        }
    }

    static final class HttpTcpClient
    extends TcpClient {
        final TcpClient defaultClient;

        HttpTcpClient(TcpClient defaultClient) {
            this.defaultClient = defaultClient;
        }

        @Override
        public Mono<? extends Connection> connect(Bootstrap b) {
            SslProvider ssl = SslProvider.findSslSupport(b);
            if (b.config().group() == null) {
                HttpResources loops = HttpResources.get();
                EventLoopGroup elg = loops.onClient(LoopResources.DEFAULT_NATIVE);
                ((Bootstrap)b.group(elg)).channel(loops.onChannel(elg));
            }
            HttpClientConfiguration conf = HttpClientConfiguration.getAndClean(b);
            ClientCookieEncoder cookieEncoder = conf.cookieEncoder;
            ClientCookieDecoder cookieDecoder = conf.cookieDecoder;
            BootstrapHandlers.channelOperationFactory(b, (ch, c, msg) -> new HttpClientOperations(ch, c, cookieEncoder, cookieDecoder));
            if (ssl != null) {
                if (ssl.getDefaultConfigurationType() == null) {
                    switch (conf.protocols) {
                        case 4: {
                            ssl = SslProvider.updateDefaultConfiguration(ssl, SslProvider.DefaultConfigurationType.TCP);
                            break;
                        }
                        case 2: {
                            ssl = SslProvider.updateDefaultConfiguration(ssl, SslProvider.DefaultConfigurationType.H2);
                        }
                    }
                }
                SslProvider.setBootstrap(b, ssl);
            }
            SslProvider defaultSsl = ssl;
            if (conf.deferredConf != null) {
                return Mono.fromCallable(() -> new HttpClientConfiguration(conf)).transform(conf.deferredConf).flatMap(c -> new MonoHttpConnect(b, (HttpClientConfiguration)c, this.defaultClient, defaultSsl));
            }
            return new MonoHttpConnect(b, conf, this.defaultClient, defaultSsl);
        }

        @Override
        public Bootstrap configure() {
            return this.defaultClient.configure();
        }

        @Override
        @Nullable
        public ProxyProvider proxyProvider() {
            return this.defaultClient.proxyProvider();
        }

        @Override
        @Nullable
        public SslProvider sslProvider() {
            return this.defaultClient.sslProvider();
        }
    }
}

