/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientMetricsRecorder;
import java.net.SocketAddress;
import java.time.Duration;

final class HttpClientMetricsHandler
extends ChannelDuplexHandler {
    HttpRequest request;
    HttpResponse response;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final HttpClientMetricsRecorder recorder;

    HttpClientMetricsHandler(HttpClientMetricsRecorder recorder) {
        this.recorder = recorder;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            this.dataSentTime = System.currentTimeMillis();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                SocketAddress address = ctx.channel().remoteAddress();
                this.recorder.recordDataSentTime(address, this.request.uri(), this.request.method().name(), Duration.ofMillis(System.currentTimeMillis() - this.dataSentTime));
                this.recorder.recordDataSent(address, this.request.uri(), this.dataSent);
            }));
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            this.response = (HttpResponse)msg;
            this.dataReceivedTime = System.currentTimeMillis();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            SocketAddress address = ctx.channel().remoteAddress();
            this.recorder.recordDataReceivedTime(address, this.request.uri(), this.request.method().name(), this.response.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataReceivedTime));
            this.recorder.recordResponseTime(address, this.request.uri(), this.request.method().name(), this.response.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataSentTime));
            this.recorder.recordDataReceived(address, this.request.uri(), this.dataReceived);
            this.reset();
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.recorder.incrementErrorsCount(ctx.channel().remoteAddress(), this.request.uri());
        ctx.fireExceptionCaught(cause);
    }

    private void reset() {
        this.request = null;
        this.response = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

