/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoProcessor;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientState;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketOutbound;
import java.net.URI;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class WebsocketClientOperations
extends HttpClientOperations
implements WebsocketInbound,
WebsocketOutbound {
    final WebSocketClientHandshaker handshaker;
    final MonoProcessor<WebSocketCloseStatus> onCloseState;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<WebsocketClientOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketClientOperations.class, "closeSent");

    WebsocketClientOperations(URI currentURI, String protocols, int maxFramePayloadLength, HttpClientOperations replaced) {
        super(replaced);
        Channel channel = this.channel();
        this.onCloseState = MonoProcessor.create();
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(currentURI, WebSocketVersion.V13, protocols.isEmpty() ? null : protocols, true, replaced.requestHeaders().remove(HttpHeaderNames.HOST), maxFramePayloadLength);
        this.handshaker.handshake(channel).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            this.markPersistent(false);
            channel.read();
        }));
    }

    @Override
    public HttpHeaders headers() {
        return this.responseHeaders();
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.actualSubprotocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.started = true;
            this.channel().pipeline().remove(HttpObjectAggregator.class);
            FullHttpResponse response = (FullHttpResponse)msg;
            this.setNettyResponse(response);
            if (this.notRedirected(response)) {
                try {
                    this.handshaker.finishHandshake(this.channel(), response);
                    this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                }
                finally {
                    response.content().release();
                }
            }
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            this.channel().writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            ctx.read();
            return;
        }
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            this.onInboundComplete();
            CloseWebSocketFrame close = (CloseWebSocketFrame)msg;
            this.sendCloseNow(new CloseWebSocketFrame(true, close.rsv(), close.content()));
        } else if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Cancelling Websocket inbound. Closing Websocket"));
        }
        this.sendCloseNow(null);
    }

    @Override
    protected void onInboundClose() {
        this.terminate();
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendCloseNow(new CloseWebSocketFrame(1002, "Client internal error"));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.onNext(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(@io.micrometer.shaded.reactor.util.annotation.Nullable CloseWebSocketFrame frame) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            if (frame != null) {
                this.onCloseState.onNext(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
            } else {
                this.onCloseState.onNext(new WebSocketCloseStatus(-1, ""));
                this.channel().writeAndFlush(new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
            }
        } else if (frame != null) {
            frame.release();
        }
    }
}

