/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.micrometer.shaded.io.netty.handler.codec.http2.HttpConversionUtil;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.http.server.ConnectionInfo;
import io.micrometer.shaded.reactor.netty.http.server.HAProxyMessageReader;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.netty.http.server.HttpToH2Operations;
import java.net.InetSocketAddress;
import java.util.Optional;

final class Http2StreamBridgeHandler
extends ChannelDuplexHandler {
    final boolean readForwardHeaders;
    Boolean secured;
    InetSocketAddress remoteAddress;
    final ConnectionObserver listener;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;

    Http2StreamBridgeHandler(ConnectionObserver listener, boolean readForwardHeaders, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        this.readForwardHeaders = readForwardHeaders;
        this.listener = listener;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http2 connection, requesting read"));
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.secured == null) {
            this.secured = ctx.channel().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel())).orElse(((SocketChannel)ctx.channel()).remoteAddress());
        }
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            HttpRequest request = headersFrame.isEndStream() ? HttpConversionUtil.toFullHttpRequest(-1, headersFrame.headers(), ctx.channel().alloc(), false) : HttpConversionUtil.toHttpRequest(-1, headersFrame.headers(), false);
            HttpToH2Operations ops = new HttpToH2Operations(Connection.from(ctx.channel()), this.listener, request, headersFrame.headers(), ConnectionInfo.from(ctx.channel().parent(), this.readForwardHeaders, request, this.secured, this.remoteAddress), this.cookieEncoder, this.cookieDecoder);
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Http2Headers) {
            msg = new DefaultHttp2HeadersFrame((Http2Headers)msg);
        }
        boolean endOfHttp2Stream = false;
        if (msg instanceof Http2DataFrame) {
            endOfHttp2Stream = ((Http2DataFrame)msg).isEndStream();
        }
        if (!endOfHttp2Stream && msg instanceof ByteBuf && ctx.channel() instanceof Http2StreamChannel) {
            msg = new DefaultHttp2DataFrame((ByteBuf)msg);
        }
        ctx.write(msg, promise);
    }
}

