/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.http.server.HttpServer;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperator;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerRequest;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerResponse;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerState;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

final class HttpServerHandle
extends HttpServerOperator
implements ConnectionObserver,
Function<ServerBootstrap, ServerBootstrap> {
    final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;

    HttpServerHandle(HttpServer server, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        super(server);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    protected TcpServer tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == HttpServerState.REQUEST_RECEIVED) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Handler is being applied: {}"), this.handler);
                }
                HttpServerOperations ops = (HttpServerOperations)connection;
                Mono.fromDirect(this.handler.apply(ops, ops)).subscribe(ops.disposeSubscriber());
            }
            catch (Throwable t) {
                log.error(ReactorNetty.format(connection.channel(), ""), t);
                connection.channel().close();
            }
        }
    }

    @Override
    public ServerBootstrap apply(ServerBootstrap b) {
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }
}

