/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoProcessor;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketOutbound;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class WebsocketServerOperations
extends HttpServerOperations
implements WebsocketInbound,
WebsocketOutbound {
    final WebSocketServerHandshaker handshaker;
    final ChannelPromise handshakerResult;
    final MonoProcessor<WebSocketCloseStatus> onCloseState;
    volatile int closeSent;
    static final AtomicIntegerFieldUpdater<WebsocketServerOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketServerOperations.class, "closeSent");

    WebsocketServerOperations(String wsUrl, @Nullable String protocols, int maxFramePayloadLength, HttpServerOperations replaced) {
        super(replaced);
        Channel channel = replaced.channel();
        this.onCloseState = MonoProcessor.create();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, protocols, true, maxFramePayloadLength);
        this.handshaker = wsFactory.newHandshaker(replaced.nettyRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
            this.handshakerResult = null;
        } else {
            this.removeHandler("io.micrometer.shaded.reactor.left.httpTrafficHandler");
            this.removeHandler("io.micrometer.shaded.reactor.left.httpMetricsHandler");
            this.handshakerResult = channel.newPromise();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (this.channel().pipeline().get("io.micrometer.shaded.reactor.left.compressionHandler") != null) {
                this.removeHandler("io.micrometer.shaded.reactor.left.compressionHandler");
                WebSocketServerCompressionHandler wsServerCompressionHandler = new WebSocketServerCompressionHandler();
                try {
                    wsServerCompressionHandler.channelRead(channel.pipeline().context("io.micrometer.shaded.reactor.right.reactiveBridge"), request);
                    this.addHandlerFirst("io.micrometer.shaded.reactor.left.wsCompressionHandler", wsServerCompressionHandler);
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format(this.channel(), ""), e);
                }
            }
            this.handshaker.handshake(channel, (HttpRequest)request, replaced.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.markPersistent(false)));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public HttpHeaders headers() {
        return this.requestHeaders();
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object frame) {
        if (frame instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)frame).isFinalFragment()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            this.onInboundComplete();
            CloseWebSocketFrame close = (CloseWebSocketFrame)frame;
            this.sendCloseNow(new CloseWebSocketFrame(true, close.rsv(), close.content()), f -> this.terminate());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)frame).content()));
            ctx.read();
            return;
        }
        if (frame != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, frame);
        }
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            this.sendCloseNow(new CloseWebSocketFrame(1002, "Server internal error"), f -> this.terminate());
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Cancelling Websocket inbound. Closing Websocket"));
        }
        this.sendCloseNow(null, f -> this.terminate());
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.onNext(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(@Nullable CloseWebSocketFrame frame, ChannelFutureListener listener) {
        if (frame != null && !frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            if (frame != null) {
                this.onCloseState.onNext(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                this.channel().writeAndFlush(frame).addListener(listener);
            } else {
                this.onCloseState.onNext(new WebSocketCloseStatus(-1, ""));
                this.channel().writeAndFlush(new CloseWebSocketFrame()).addListener(listener);
            }
        } else if (frame != null) {
            frame.release();
        }
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    public String selectedSubprotocol() {
        return this.handshaker.selectedSubprotocol();
    }
}

