/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import java.time.Duration;
import java.util.function.Function;

public interface Pool<POOLABLE>
extends Disposable {
    public Mono<Integer> warmup();

    public Mono<PooledRef<POOLABLE>> acquire();

    public Mono<PooledRef<POOLABLE>> acquire(Duration var1);

    default public <V> Flux<V> withPoolable(Function<POOLABLE, Publisher<V>> scopeFunction) {
        return Flux.usingWhen(this.acquire(), slot -> {
            Object poolable = slot.poolable();
            if (poolable == null) {
                return Mono.empty();
            }
            return (Publisher)scopeFunction.apply(poolable);
        }, PooledRef::release, PooledRef::release);
    }

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    public Mono<Void> disposeLater();
}

