/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;

final class PooledConnectionProviderMetrics {
    static final MeterRegistry registry = Metrics.globalRegistry;
    static final String NAME = "io.micrometer.shaded.reactor.netty.connection.provider.%s";
    static final String TOTAL_CONNECTIONS = ".total.connections";
    static final String ACTIVE_CONNECTIONS = ".active.connections";
    static final String IDLE_CONNECTIONS = ".idle.connections";
    static final String PENDING_CONNECTIONS = ".pending.connections";
    static final String ID = "id";

    PooledConnectionProviderMetrics() {
    }

    static void registerMetrics(String poolName, String id, String remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String name = String.format(NAME, poolName);
        Gauge.builder((String)(name + TOTAL_CONNECTIONS), (Object)metrics, InstrumentedPool.PoolMetrics::allocatedSize).description("The number of all connections, active or idle.").tags(new String[]{ID, id, "remote.address", remoteAddress}).register(registry);
        Gauge.builder((String)(name + ACTIVE_CONNECTIONS), (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).description("The number of the connections that have been successfully acquired and are in active use").tags(new String[]{ID, id, "remote.address", remoteAddress}).register(registry);
        Gauge.builder((String)(name + IDLE_CONNECTIONS), (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).description("The number of the idle connections").tags(new String[]{ID, id, "remote.address", remoteAddress}).register(registry);
        Gauge.builder((String)(name + PENDING_CONNECTIONS), (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description("The number of the request, that are pending acquire a connection").tags(new String[]{ID, id, "remote.address", remoteAddress}).register(registry);
    }
}

