/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.util.EnvironmentProperties;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@AOTModule(id="precompute.environment.properties", description="Precomputes Micronaut configuration property keys from the current environment variables")
public class EnvironmentPropertiesSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "precompute.environment.properties";
    public static final String DESCRIPTION = "Precomputes Micronaut configuration property keys from the current environment variables";
    private static final int MAX_METHOD_SIZE = 30000;
    private final Map<String, String> env;

    public EnvironmentPropertiesSourceGenerator(Map<String, String> env) {
        this.env = env;
    }

    public EnvironmentPropertiesSourceGenerator() {
        this(CachedEnvironment.getenv());
    }

    public void generate(@NonNull AOTContext context) {
        String className = "EnvironmentPropertiesOptimizationLoader";
        EnvironmentProperties props = EnvironmentProperties.empty();
        this.env.keySet().forEach(arg_0 -> ((EnvironmentProperties)props).findPropertyNamesForEnvironmentVariable(arg_0));
        MethodSpec.Builder mainLoadMethodBuilder = MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(EnvironmentProperties.class).addStatement("$T env = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})}), ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})})});
        TypeSpec.Builder generatedTypeBuilder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get(StaticOptimizations.Loader.class, (Type[])new Type[]{EnvironmentProperties.class}));
        int fixedLineSize = 37;
        int methodSize = 0;
        int index = 0;
        MethodSpec.Builder loadMethodBuilder = this.createMethodBuilder(index);
        for (Map.Entry entry : props.asMap().entrySet()) {
            String values = ((List)entry.getValue()).stream().map(e -> "\"" + e + "\"").collect(Collectors.joining(", "));
            if ((methodSize += fixedLineSize + ((String)entry.getKey()).length() + values.length() + 2) > 30000) {
                generatedTypeBuilder.addMethod(loadMethodBuilder.build());
                mainLoadMethodBuilder.addCode("load" + index + "(env);\n", new Object[0]);
                methodSize = 0;
                loadMethodBuilder = this.createMethodBuilder(++index);
            }
            loadMethodBuilder.addStatement("env.put($S, $T.asList($L))", new Object[]{entry.getKey(), Arrays.class, values});
        }
        generatedTypeBuilder.addMethod(loadMethodBuilder.build());
        mainLoadMethodBuilder.addCode("load" + index + "(env);\n", new Object[0]).addStatement("return $T.of(env)", new Object[]{EnvironmentProperties.class});
        generatedTypeBuilder.addMethod(mainLoadMethodBuilder.build());
        context.registerGeneratedSourceFile(context.javaFile(generatedTypeBuilder.build()));
        context.registerServiceImplementation(StaticOptimizations.Loader.class, className);
    }

    MethodSpec.Builder createMethodBuilder(int index) {
        return MethodSpec.methodBuilder((String)("load" + index)).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})}), "env", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
    }
}

