/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.ParameterizedTypeName;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AOTModule(id="known.missing.types", description="Checks of existence of some types at build time instead of runtime", options={@Option(key="known.missing.types.list", description="A list of types that the AOT analyzer needs to check for existence (comma separated)", sampleValue="io.reactivex.Observable,reactor.core.publisher.Flux,kotlinx.coroutines.flow.Flow,io.reactivex.rxjava3.core.Flowable,io.reactivex.rxjava3.core.Observable,io.reactivex.Single,reactor.core.publisher.Mono,io.reactivex.Maybe,io.reactivex.rxjava3.core.Single,io.reactivex.rxjava3.core.Maybe,io.reactivex.Completable,io.reactivex.rxjava3.core.Completable,io.methvin.watchservice.MacOSXListeningWatchService,io.micronaut.core.async.publisher.CompletableFuturePublisher,io.micronaut.core.async.publisher.Publishers.JustPublisher,io.micronaut.core.async.subscriber.Completable")})
public class KnownMissingTypesSourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "known.missing.types";
    public static final Option OPTION = ((AOTModule)MetadataUtils.findMetadata(KnownMissingTypesSourceGenerator.class).get()).options()[0];
    public static final String DESCRIPTION = "Checks of existence of some types at build time instead of runtime";

    private List<String> findMissingClasses(List<String> classNames) {
        ArrayList<String> knownMissingClasses = new ArrayList<String>();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        for (String name : classNames) {
            try {
                cl.loadClass(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                knownMissingClasses.add(name);
            }
        }
        return knownMissingClasses;
    }

    public void generate(@NonNull AOTContext context) {
        context.registerStaticOptimization("KnownMissingTypesOptimizationLoader", ClassUtils.Optimizations.class, body -> {
            List classNames = context.getConfiguration().stringList(OPTION.key());
            body.addStatement("$T knownMissingTypes = new $T()", new Object[]{ParameterizedTypeName.get(Set.class, (Type[])new Type[]{String.class}), ParameterizedTypeName.get(HashSet.class, (Type[])new Type[]{String.class})});
            for (String knownMissingClass : this.findMissingClasses(classNames)) {
                body.addStatement("knownMissingTypes.add($S)", new Object[]{knownMissingClass});
            }
            body.addStatement("return new $T(knownMissingTypes)", new Object[]{ClassUtils.Optimizations.class});
        });
    }
}

