/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.utils;

import io.micronaut.jsonschema.generator.utils.SourceGeneratorConfigBuilder;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;

public record SourceGeneratorConfig(InputStream inputStream, String jsonUrl, File jsonFile, Path inputFolder, Path outputPath, String outputPackageName, String outputFileName, JavadocConfig javadoc, RecordAdoptionStrategy recordAdoptionStrategy) {
    public String getInputName() {
        if (this.jsonFile != null) {
            return this.jsonFile.getName();
        }
        if (this.jsonUrl != null && !this.jsonUrl.isBlank()) {
            return this.jsonUrl.substring(this.jsonUrl.lastIndexOf(47) + 1);
        }
        return "InputStream.schema.json";
    }

    public SourceGeneratorConfigBuilder toBuilder() {
        return new SourceGeneratorConfigBuilder().withInputStream(this.inputStream).withJsonUrl(this.jsonUrl).withInputFolder(this.inputFolder).withJsonFile(this.jsonFile).withOutputFolder(this.outputPath).withOutputPackageName(this.outputPackageName).withOutputFileName(this.outputFileName).withJavadoc(this.javadoc).withRecordAdoptionStrategy(this.recordAdoptionStrategy);
    }

    public record JavadocConfig(boolean replaceHTML) {
        public JavadocConfig() {
            this(true);
        }
    }

    public static enum RecordAdoptionStrategy {
        PREFER_RECORD,
        ALWAYS_CLASS;

    }
}

