/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.propagation.instrument.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

@Internal
public class ContextPropagatingExecutorService
implements InstrumentedExecutorService {
    private final ExecutorService target;
    private final PropagatedContext propagatedContext;

    public ContextPropagatingExecutorService(ExecutorService target) {
        this(target, null);
    }

    public ContextPropagatingExecutorService(ExecutorService target, @Nullable PropagatedContext propagatedContext) {
        this.target = target;
        this.propagatedContext = propagatedContext;
    }

    public ExecutorService getTarget() {
        return this.target;
    }

    public <T> Callable<T> instrument(Callable<T> task) {
        if (this.propagatedContext != null) {
            return this.propagatedContext.wrap(task);
        }
        return PropagatedContext.wrapCurrent(task);
    }

    public Runnable instrument(Runnable task) {
        if (this.propagatedContext != null) {
            return this.propagatedContext.wrap(task);
        }
        return PropagatedContext.wrapCurrent((Runnable)task);
    }

    public static Optional<ExecutorService> unwrap(ExecutorService executorService) {
        if (!(executorService instanceof InstrumentedExecutorService)) {
            return Optional.empty();
        }
        ExecutorService target = executorService;
        while (target instanceof InstrumentedExecutorService) {
            InstrumentedExecutorService ies = (InstrumentedExecutorService)target;
            if (target instanceof ContextPropagatingExecutorService) {
                ContextPropagatingExecutorService contextPropagatingExecutorService = (ContextPropagatingExecutorService)((Object)target);
                return Optional.of(contextPropagatingExecutorService.getTarget());
            }
            target = ies.getTarget();
        }
        return Optional.empty();
    }

    public static boolean isInstrumented(ExecutorService executorService) {
        InstrumentedExecutorService ies;
        return executorService instanceof InstrumentedExecutorService && ContextPropagatingExecutorService.unwrap((ExecutorService)(ies = (InstrumentedExecutorService)executorService)).isPresent();
    }
}

