/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public interface InstrumentedExecutor
extends Executor,
RunnableInstrumenter {
    public static Executor unwrap(Executor executor) {
        if (executor instanceof InstrumentedExecutor) {
            InstrumentedExecutor instrumentedExecutor = (InstrumentedExecutor)executor;
            return instrumentedExecutor.getTarget();
        }
        return executor;
    }

    public static ExecutorService unwrap(ExecutorService executor) {
        if (executor instanceof InstrumentedExecutor) {
            InstrumentedExecutor instrumentedExecutor = (InstrumentedExecutor)((Object)executor);
            return (ExecutorService)instrumentedExecutor.getTarget();
        }
        return executor;
    }

    public Executor getTarget();

    @Override
    default public void execute(@NonNull Runnable command) {
        this.getTarget().execute(this.instrument(command));
    }
}

