/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.functional.ThrowingConsumer;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.stream.AvailableByteArrayBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class ByteBodyFactory {
    private final ByteBufferFactory<?, ?> byteBufferFactory;

    @Internal
    protected ByteBodyFactory(@NonNull ByteBufferFactory<?, ?> byteBufferFactory) {
        this.byteBufferFactory = byteBufferFactory;
    }

    @NonNull
    public static ByteBodyFactory createDefault(@NonNull ByteBufferFactory<?, ?> byteBufferFactory) {
        return new ByteBodyFactory(byteBufferFactory);
    }

    @NonNull
    public final ByteBufferFactory<?, ?> byteBufferFactory() {
        return this.byteBufferFactory;
    }

    @NonNull
    public CloseableAvailableByteBody adapt(@NonNull ByteBuffer<?> buffer) {
        byte[] byteArray = buffer.toByteArray();
        if (buffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)buffer;
            rc.release();
        }
        return this.adapt(byteArray);
    }

    @NonNull
    public CloseableAvailableByteBody adapt(byte @NonNull [] array) {
        return AvailableByteArrayBody.create(this.byteBufferFactory(), array);
    }

    @NonNull
    public <T extends Throwable> CloseableAvailableByteBody buffer(@NonNull ThrowingConsumer<? super OutputStream, T> writer) throws T {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        writer.accept((Object)s);
        return AvailableByteArrayBody.create(this.byteBufferFactory(), s.toByteArray());
    }

    @NonNull
    public CloseableAvailableByteBody createEmpty() {
        return this.adapt(ArrayUtils.EMPTY_BYTE_ARRAY);
    }

    @NonNull
    public CloseableAvailableByteBody copyOf(@NonNull CharSequence cs, @NonNull Charset charset) {
        return this.adapt(cs.toString().getBytes(charset));
    }

    @NonNull
    @Blocking
    public CloseableAvailableByteBody copyOf(@NonNull InputStream stream) throws IOException {
        return this.adapt(stream.readAllBytes());
    }
}

