/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringCompositeQualifier;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
final class CompositeQualifier<T>
implements Qualifier<T> {
    private final Qualifier<T>[] qualifiers;

    CompositeQualifier(Qualifier<T>[] qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        Stream<BT> reduced = candidates;
        for (Qualifier<T> qualifier : this.qualifiers) {
            reduced = qualifier.reduce(beanType, reduced);
        }
        return reduced;
    }

    @Override
    public <BT extends BeanType<T>> Collection<BT> filter(Class<T> beanType, Collection<BT> candidates) {
        for (Qualifier<T> qualifier : this.qualifiers) {
            candidates = qualifier.filter(beanType, candidates);
        }
        return candidates;
    }

    public Qualifier<T>[] getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public boolean contains(Qualifier<T> qualifier) {
        if (qualifier instanceof CompositeQualifier) {
            CompositeQualifier compositeQualifier = (CompositeQualifier)qualifier;
            for (Qualifier<T> q : compositeQualifier.qualifiers) {
                if (this.contains(q)) continue;
                return false;
            }
            return true;
        }
        if (qualifier instanceof FilteringCompositeQualifier) {
            FilteringCompositeQualifier filteringCompositeQualifier = (FilteringCompositeQualifier)qualifier;
            for (FilteringQualifier q : filteringCompositeQualifier.getQualifiers()) {
                if (this.contains(q)) continue;
                return false;
            }
            return true;
        }
        for (Qualifier<T> q : this.qualifiers) {
            if (!q.contains(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeQualifier that = (CompositeQualifier)o;
        return Arrays.equals(this.qualifiers, that.qualifiers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.qualifiers);
    }

    public String toString() {
        return Arrays.stream(this.qualifiers).map(Object::toString).collect(Collectors.joining(" and "));
    }
}

