/*
 * Copyright 2017-2023 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import org.reactivestreams.Publisher;

/**
 * Client for loading Json Web Key Set content over http.
 *
 * @author Jeremy Grelle
 * @since 4.5.0
 */
@FunctionalInterface
public interface JwksClient {

    /**
     * Loads remote Json Web Key Set content over http.
     *
     * @param providerName The jwks provider name
     * @param url The URL for loading the remote JWK Set
     * @return The JWK Set response body content
     */
    @Nullable
    @SingleResult
    Publisher<String> load(@Nullable String providerName, @NonNull String url);
}
