/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor;

import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.annotation.SerdeImport;
import io.micronaut.serde.annotation.Serdeable;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import java.lang.annotation.Annotation;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SerdeAnnotationVisitor
implements TypeElementVisitor<SerdeConfig, SerdeConfig> {
    private static final String DEFAULT_REF_ALIAS_NAME = "defaultReference";
    private boolean failOnError = true;
    private ClassElement currentClass;
    private MethodElement anyGetterMethod;
    private MethodElement anySetterMethod;
    private FieldElement anyGetterField;
    private FieldElement anySetterField;
    private MethodElement jsonValueMethod;
    private FieldElement jsonValueField;
    private final Set<MethodElement> readMethods = new HashSet<MethodElement>(20);
    private final Set<MethodElement> writeMethods = new HashSet<MethodElement>(20);
    private final Set<String> elementVisitedAsSubtype = new HashSet<String>(10);
    private SerdeConfig.SerCreatorMode creatorMode = SerdeConfig.SerCreatorMode.PROPERTIES;

    public Set<String> getSupportedAnnotationNames() {
        return CollectionUtils.setOf((Object[])new String[]{"com.fasterxml.jackson.annotation.*", "jakarta.json.bind.annotation.*", "io.micronaut.serde.annotation.*", "org.bson.codecs.pojo.annotations.*", "io.micronaut.serde.config.annotation.*", "com.fasterxml.jackson.databind.annotation.*"});
    }

    private Set<String> getUnsupportedJacksonAnnotations() {
        return CollectionUtils.setOf((Object[])new String[]{"com.fasterxml.jackson.annotation.JsonKey", "com.fasterxml.jackson.annotation.JsonAutoDetect", "com.fasterxml.jackson.annotation.JsonMerge", "com.fasterxml.jackson.annotation.JsonIdentityInfo", "com.fasterxml.jackson.annotation.JsonIdentityReference"});
    }

    public void visitField(FieldElement element, VisitorContext context) {
        this.checkForErrors((Element)element, context);
        this.checkForFieldErrors(element);
    }

    private void checkForFieldErrors(FieldElement element) {
        if (!this.failOnError) {
            return;
        }
        if (element.hasDeclaredAnnotation(SerdeConfig.SerAnyGetter.class)) {
            if (element.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                throw new ProcessingException((Element)element, "A field annotated with AnyGetter cannot be unwrapped");
            }
            if (element.hasDeclaredAnnotation(SerdeConfig.SerValue.class)) {
                throw new ProcessingException((Element)element, "A field annotated with AnyGetter cannot be a JsonValue");
            }
            if (!element.getGenericField().isAssignable(Map.class)) {
                throw new ProcessingException((Element)element, "A field annotated with AnyGetter must be a Map");
            }
            if (this.anyGetterField != null) {
                throw new ProcessingException((Element)element, "Only a single AnyGetter field is supported, another defined: " + this.anyGetterField.getDescription(true));
            }
            if (this.anyGetterMethod != null) {
                throw new ProcessingException((Element)element, "Cannot define both an AnyGetter field and an AnyGetter method: " + this.anyGetterMethod.getDescription(true));
            }
            this.anyGetterField = element;
        } else if (element.hasDeclaredAnnotation(SerdeConfig.SerAnySetter.class)) {
            if (this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING) {
                throw new ProcessingException((Element)element, "A field annotated with AnySetter cannot use DELEGATING creation");
            }
            if (element.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                throw new ProcessingException((Element)element, "A field annotated with AnySetter cannot be unwrapped");
            }
            if (!element.getGenericField().isAssignable(Map.class)) {
                throw new ProcessingException((Element)element, "A field annotated with AnySetter must be a Map");
            }
            if (this.anySetterField != null) {
                throw new ProcessingException((Element)element, "Only a single AnySetter field is supported, another defined: " + this.anySetterField.getDescription(true));
            }
            if (this.anySetterMethod != null) {
                throw new ProcessingException((Element)element, "Cannot define both an AnySetter field and an AnySetter method: " + this.anySetterMethod.getDescription(true));
            }
            this.anySetterField = element;
        } else if (element.hasDeclaredAnnotation(SerdeConfig.SerValue.class)) {
            if (this.jsonValueField != null) {
                throw new ProcessingException((Element)element, "A JsonValue field is already defined: " + this.jsonValueField);
            }
            if (this.jsonValueMethod != null) {
                throw new ProcessingException((Element)element, "A JsonValue method is already defined: " + this.jsonValueMethod);
            }
            this.jsonValueField = element;
        }
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        this.checkForErrors((Element)element, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMethod(MethodElement element, VisitorContext context) {
        this.checkForErrors((Element)element, context);
        MutableAnnotationMetadataDelegate methodMetadata = element.getMethodAnnotationMetadata();
        if (methodMetadata.hasDeclaredAnnotation("Property") || methodMetadata.stringValue(SerdeConfig.class, "property").isPresent()) {
            ParameterElement[] parameters = element.getParameters();
            if (element.isStatic()) {
                throw new ProcessingException((Element)element, "A method annotated with JsonProperty cannot be static");
            }
            if (parameters.length == 0) {
                if (element.getReturnType().getName().equals("void")) {
                    throw new ProcessingException((Element)element, "A method annotated with JsonProperty cannot return void");
                }
                if (this.readMethods.contains(element)) return;
                element.annotate(Executable.class);
                element.annotate(SerdeConfig.SerGetter.class);
                return;
            } else {
                if (parameters.length != 1) throw new ProcessingException((Element)element, "A method annotated with JsonProperty must specify at most 1 argument");
                if (this.writeMethods.contains(element)) return;
                element.annotate(Executable.class);
                element.annotate(SerdeConfig.SerSetter.class);
            }
            return;
        } else {
            if (methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerGetter.class)) {
                if (element.isStatic()) {
                    throw new ProcessingException((Element)element, "A method annotated with JsonGetter cannot be static");
                }
                if (element.getReturnType().getName().equals("void")) {
                    throw new ProcessingException((Element)element, "A method annotated with JsonGetter cannot return void");
                }
                if (!element.hasParameters()) return;
                throw new ProcessingException((Element)element, "A method annotated with JsonGetter cannot define arguments");
            }
            if (methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerSetter.class)) {
                if (element.isStatic()) {
                    throw new ProcessingException((Element)element, "A method annotated with JsonSetter cannot be static");
                }
                ParameterElement[] parameters = element.getParameters();
                if (parameters.length == 1) return;
                throw new ProcessingException((Element)element, "A method annotated with JsonSetter must specify exactly 1 argument");
            }
            if (methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerAnyGetter.class)) {
                if (this.anyGetterMethod != null) {
                    throw new ProcessingException((Element)element, "Type already defines a method annotated with JsonAnyGetter: " + this.anyGetterMethod.getDescription(true));
                }
                this.anyGetterMethod = element;
                if (methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                    throw new ProcessingException((Element)element, "A method annotated with AnyGetter cannot be unwrapped");
                }
                if (element.isStatic()) {
                    throw new ProcessingException((Element)element, "A method annotated with AnyGetter cannot be static");
                }
                if (!element.getGenericReturnType().isAssignable(Map.class)) {
                    throw new ProcessingException((Element)element, "A method annotated with AnyGetter must return a Map");
                }
                if (!element.hasParameters()) return;
                throw new ProcessingException((Element)element, "A method annotated with AnyGetter cannot define arguments");
            }
            if (methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerAnySetter.class)) {
                if (this.anySetterMethod != null) {
                    throw new ProcessingException((Element)element, "Type already defines a method annotated with JsonAnySetter: " + this.anySetterMethod.getDescription(true));
                }
                this.anySetterMethod = element;
                if (methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerUnwrapped.class)) {
                    throw new ProcessingException((Element)element, "A method annotated with AnyGetter cannot be unwrapped");
                }
                if (element.isStatic()) {
                    throw new ProcessingException((Element)element, "A method annotated with AnySetter cannot be static");
                }
                ParameterElement[] parameters = element.getParameters();
                if (!(parameters.length == 1 ? !parameters[0].getGenericType().isAssignable(Map.class) : parameters.length != 2 || !parameters[0].getGenericType().isAssignable(String.class))) return;
                throw new ProcessingException((Element)element, "A method annotated with AnySetter must either define a single parameter of type Map or define exactly 2 parameters, the first of which should be of type String");
            }
            if (!methodMetadata.hasDeclaredAnnotation(SerdeConfig.SerValue.class)) return;
            if (this.jsonValueField != null) {
                throw new ProcessingException((Element)element, "A JsonValue field is already defined: " + this.jsonValueField);
            }
            if (this.jsonValueMethod != null) {
                throw new ProcessingException((Element)element, "A JsonValue method is already defined: " + this.jsonValueMethod);
            }
            this.jsonValueMethod = element;
        }
    }

    private void checkForErrors(Element element, VisitorContext context) {
        String pattern;
        Class t;
        String defaultValue;
        if (!this.failOnError) {
            return;
        }
        if (element instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)element;
            if (this.readMethods.contains(methodElement) && !methodElement.hasParameters()) {
                return;
            }
            if (this.writeMethods.contains(methodElement) && methodElement.getParameters().length == 1) {
                return;
            }
        }
        if (element instanceof MethodElement && element.hasDeclaredAnnotation(SerdeConfig.class) && element.isPrivate()) {
            throw new ProcessingException(element, "JSON annotations cannot be used on private methods and constructors");
        }
        for (String annotation : this.getUnsupportedJacksonAnnotations()) {
            if (!element.hasDeclaredAnnotation(annotation)) continue;
            throw new ProcessingException(element, "Annotation @" + NameUtils.getSimpleName((String)annotation) + " is not supported");
        }
        String error = element.stringValue(SerdeConfig.SerError.class).orElse(null);
        if (error != null) {
            throw new ProcessingException(element, error);
        }
        ClassElement propertyType = this.resolvePropertyType(element);
        if (propertyType == null) {
            return;
        }
        boolean isBasicType = SerdeAnnotationVisitor.isBasicType(propertyType);
        if (isBasicType && (defaultValue = (String)element.stringValue(Bindable.class, "defaultValue").orElse(null)) != null && (t = propertyType.isPrimitive() ? (Class)ClassUtils.getPrimitiveType((String)propertyType.getName()).map(ReflectionUtils::getWrapperType).orElse(null) : (Class)ClassUtils.forName((String)propertyType.getName(), (ClassLoader)this.getClass().getClassLoader()).orElse(null)) != null) {
            try {
                if (ConversionService.SHARED.canConvert(String.class, t)) {
                    ConversionService.SHARED.convertRequired((Object)defaultValue, t);
                }
            }
            catch (ConversionErrorException e) {
                throw new ProcessingException(element, "Invalid defaultValue [" + defaultValue + "] specified: " + e.getConversionError().getCause().getMessage());
            }
        }
        if ((pattern = (String)element.stringValue(SerdeConfig.class, "pattern").orElse(null)) != null && this.failOnError) {
            if (this.isNumberType(propertyType)) {
                try {
                    new DecimalFormat(pattern);
                }
                catch (Exception e) {
                    throw new ProcessingException(element, "Specified pattern [" + pattern + "] is not a valid decimal format. See the javadoc for DecimalFormat: " + e.getMessage());
                }
            }
            if (propertyType.isAssignable(Temporal.class)) {
                try {
                    DateTimeFormatter.ofPattern(pattern);
                }
                catch (Exception e) {
                    throw new ProcessingException(element, "Specified pattern [" + pattern + "] is not a valid date format. See the javadoc for DateTimeFormatter: " + e.getMessage());
                }
            }
        }
        this.handleReferences(element, context, propertyType, isBasicType);
        if (this.hasAnnotationOnElement(element, SerdeConfig.SerUnwrapped.class)) {
            if (SerdeAnnotationVisitor.isBasicType(propertyType)) {
                throw new ProcessingException(element, "Unwrapped cannot be declared on basic types");
            }
            List<String> thatProperties = this.resolvePropertyNames(context, propertyType, element);
            List<String> thisProperties = this.resolvePropertyNames(context, this.currentClass, null);
            for (String thisProperty : thisProperties) {
                for (String thatProperty : thatProperties) {
                    if (!thisProperty.equals(thatProperty)) continue;
                    throw new ProcessingException(element, "Unwrapped property contains a property [" + thatProperty + "] that conflicts with an existing property of the outer type: " + this.currentClass.getName() + ". Consider specifying a prefix or suffix to disambiguate this conflict.");
                }
            }
        }
    }

    private void handleReferences(Element element, VisitorContext context, ClassElement propertyType, boolean isBasicType) {
        this.handleReferenceProperty(element, context, propertyType, isBasicType, SerdeConfig.SerManagedRef.class, SerdeConfig.SerBackRef.class, "alias");
        this.handleReferenceProperty(element, context, propertyType, isBasicType, SerdeConfig.SerBackRef.class, SerdeConfig.SerManagedRef.class, "alias");
    }

    private void handleReferenceProperty(Element element, VisitorContext context, ClassElement propertyType, boolean isBasicType, Class<? extends Annotation> refClass, Class<? extends Annotation> inverseRefClass, String aliasProperty) {
        if (this.hasAnnotationOnElement(element, refClass)) {
            if (element.stringValue(refClass).isPresent()) {
                return;
            }
            if (this.hasAnnotationOnElement(element, SerdeConfig.SerUnwrapped.class)) {
                throw new ProcessingException(element, "Managed references cannot be unwrapped");
            }
            if (isBasicType) {
                throw new ProcessingException(element, "Managed references cannot be declared on basic types");
            }
            String refName = element.stringValue(refClass, aliasProperty).orElse(DEFAULT_REF_ALIAS_NAME);
            List<TypedElement> inverseElements = this.resolveInverseElements(context, this.resolveRefType(propertyType), inverseRefClass, aliasProperty, refName);
            int i = inverseElements.size();
            if (i == 0) {
                throw new ProcessingException(element, "No inverse property found for reference of type " + propertyType.getName() + " and reference: " + refName);
            }
            if (i > 1) {
                throw new ProcessingException(element, "More than one potential inverse property found " + inverseElements + ", consider specifying a value to the reference to configure the association");
            }
            TypedElement otherElement = inverseElements.iterator().next();
            if (!this.isCompatibleInverseSide(otherElement.getGenericType(), this.currentClass)) {
                throw new ProcessingException(element, "Managed reference declares an incompatible inverse property [" + otherElement + "]. The inverse side should be a map, collection, bean or array of the same type as the property.");
            }
            element.annotate(refClass, builder -> builder.value(otherElement.getName()));
        }
    }

    private boolean hasAnnotationOnElement(Element element, Class<? extends Annotation> managedRefClass) {
        return element.hasDeclaredAnnotation(managedRefClass) || element instanceof PropertyElement && element.hasAnnotation(managedRefClass);
    }

    private String resolvePropertyName(TypedElement thisProperty) {
        return thisProperty.stringValue(SerdeConfig.class, "property").orElseGet(() -> {
            if (thisProperty instanceof MethodElement) {
                return NameUtils.getPropertyNameForGetter((String)thisProperty.getName());
            }
            return thisProperty.getName();
        });
    }

    private ClassElement resolveRefType(ClassElement propertyType) {
        if (propertyType.isArray()) {
            return propertyType.fromArray();
        }
        if (propertyType.isAssignable(Iterable.class)) {
            return propertyType.getFirstTypeArgument().orElse(propertyType);
        }
        if (propertyType.isAssignable(Map.class)) {
            List boundGenericTypes = propertyType.getBoundGenericTypes();
            if (boundGenericTypes.size() == 2) {
                return (ClassElement)boundGenericTypes.get(1);
            }
            return propertyType;
        }
        return propertyType;
    }

    private List<TypedElement> resolveInverseElements(VisitorContext context, ClassElement propertyType, Class<? extends Annotation> refType, String aliasPropertyName, String ref) {
        Set<Introspected.AccessKind> accessKindSet = this.resolveAccessSet(context, propertyType);
        ArrayList<TypedElement> otherElements = new ArrayList<TypedElement>();
        if (accessKindSet.contains(Introspected.AccessKind.METHOD)) {
            propertyType.getBeanProperties().stream().filter(p -> this.isMappedCandidate(refType, aliasPropertyName, ref, (AnnotationMetadata)p) && p.hasAnnotation(refType) && this.isCompatibleInverseSide(p.getGenericType(), this.currentClass)).forEach(otherElements::add);
        }
        if (accessKindSet.contains(Introspected.AccessKind.FIELD)) {
            List fields = propertyType.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().annotated(ann -> this.isMappedCandidate(refType, aliasPropertyName, ref, (AnnotationMetadata)ann) && ann.hasDeclaredAnnotation(refType)).modifiers(m -> m.contains(ElementModifier.PUBLIC)).typed(t -> this.isCompatibleInverseSide(t.getGenericType(), this.currentClass)));
            otherElements.addAll(fields);
        }
        return otherElements;
    }

    private List<String> resolvePropertyNames(VisitorContext context, ClassElement propertyType, @Nullable Element annotationSource) {
        Stream<Object> typeElements;
        Object[] includedSource = annotationSource == null ? null : annotationSource.stringValues(SerdeConfig.SerIncluded.class);
        Object[] includedType = propertyType.stringValues(SerdeConfig.SerIncluded.class);
        Object includeSet = ArrayUtils.isEmpty((Object[])includedSource) ? (ArrayUtils.isEmpty((Object[])includedType) ? null : CollectionUtils.setOf((Object[])includedType)) : CollectionUtils.setOf((Object[])includedSource);
        Object[] ignoredSource = annotationSource == null ? null : annotationSource.stringValues(SerdeConfig.SerIgnored.class);
        Object[] ignoredType = propertyType.stringValues(SerdeConfig.SerIgnored.class);
        Object ignoreSet = ArrayUtils.isEmpty((Object[])ignoredSource) ? (ArrayUtils.isEmpty((Object[])ignoredType) ? null : CollectionUtils.setOf((Object[])ignoredType)) : CollectionUtils.setOf((Object[])ignoredSource);
        Set<Introspected.AccessKind> accessKindSet = this.resolveAccessSet(context, propertyType);
        if (accessKindSet.contains(Introspected.AccessKind.METHOD)) {
            typeElements = propertyType.getBeanProperties().stream().filter(p -> !p.hasDeclaredAnnotation(SerdeConfig.SerIgnored.class));
        } else if (accessKindSet.contains(Introspected.AccessKind.FIELD)) {
            List fields = propertyType.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().annotated(ann -> !ann.hasDeclaredAnnotation(SerdeConfig.SerIgnored.class)).modifiers(m -> m.contains(ElementModifier.PUBLIC)));
            typeElements = fields.stream();
        } else {
            typeElements = Stream.empty();
        }
        return typeElements.map(this::resolvePropertyName).filter(arg_0 -> SerdeAnnotationVisitor.lambda$resolvePropertyNames$9((Set)ignoreSet, (Set)includeSet, arg_0)).toList();
    }

    private boolean isMappedCandidate(Class<? extends Annotation> refType, String aliasPropertyName, String ref, AnnotationMetadata p) {
        return p.stringValue(refType, aliasPropertyName).orElse(DEFAULT_REF_ALIAS_NAME).equals(ref);
    }

    private Set<Introspected.AccessKind> resolveAccessSet(VisitorContext context, ClassElement propertyType) {
        Object[] accessKinds = context.getClassElement(propertyType.getName()).map(t -> (Introspected.AccessKind[])t.enumValues(Introspected.class, "accessKind", Introspected.AccessKind.class)).orElse(null);
        return ArrayUtils.isNotEmpty((Object[])accessKinds) ? CollectionUtils.setOf((Object[])accessKinds) : Collections.singleton(Introspected.AccessKind.METHOD);
    }

    private boolean isCompatibleInverseSide(ClassElement genericType, ClassElement propertyType) {
        if (genericType.isAssignable(propertyType)) {
            return true;
        }
        if (genericType.isArray() && genericType.fromArray().isAssignable(propertyType)) {
            return true;
        }
        if (genericType.isAssignable(Iterable.class) && genericType.getFirstTypeArgument().map(t -> t.isAssignable(propertyType)).orElse(false).booleanValue()) {
            return true;
        }
        if (genericType.isAssignable(Map.class)) {
            List types = genericType.getBoundGenericTypes();
            return types.size() == 2 && ((ClassElement)types.get(1)).isAssignable(propertyType);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNumberType(ClassElement type) {
        if (type == null) {
            return false;
        }
        if (type.isAssignable(Number.class)) return true;
        if (!type.isPrimitive()) return false;
        if (ClassUtils.getPrimitiveType((String)type.getName()).map(ReflectionUtils::getWrapperType).map(Number.class::isAssignableFrom).orElse(false) == false) return false;
        return true;
    }

    @Nullable
    private ClassElement resolvePropertyType(Element element) {
        ClassElement type = null;
        if (element instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)element;
            type = fieldElement.getGenericField().getType();
        } else if (element instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)element;
            type = !methodElement.hasParameters() ? methodElement.getGenericReturnType() : methodElement.getParameters()[0].getGenericType();
        } else if (element instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)element;
            return propertyElement.getGenericType();
        }
        return type;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.resetForNewClass(element);
        this.checkForErrors((Element)element, context);
        this.visitClassInternal(element, context, false);
    }

    private void visitClassSubtypes(ClassElement supertype, VisitorContext context) {
        List subtypes = supertype.getDeclaredAnnotationValuesByType(SerdeConfig.SerSubtyped.SerSubtype.class);
        for (AnnotationValue subtypeAnn : subtypes) {
            subtypeAnn.stringValue().flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).ifPresent(subtype -> {
                if (!subtype.hasStereotype(SerdeConfig.class)) {
                    subtype.annotate(Serdeable.class);
                    this.visitSubtype(supertype, (ClassElement)subtype, context);
                }
            });
        }
    }

    private void visitSubtype(ClassElement supertype, ClassElement subtype, VisitorContext context) {
        if (this.elementVisitedAsSubtype.contains(subtype.getName())) {
            return;
        }
        this.elementVisitedAsSubtype.add(subtype.getName());
        if (this.failOnError && this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING) {
            throw new ProcessingException((Element)subtype, "Inheritance cannot be combined with DELEGATING creation");
        }
        if (!subtype.hasAnnotation(SerdeConfig.SerIgnored.class)) {
            AnnotationValue serIgnored = supertype.getAnnotation(SerdeConfig.SerIgnored.class);
            if (serIgnored != null) {
                subtype.annotate(serIgnored);
            }
            this.visitProperties(subtype, context);
        }
        SerdeConfig.SerSubtyped.DiscriminatorValueKind discriminatorValueKind = this.getDiscriminatorValueKind((Element)supertype);
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = this.getDiscriminatorType((Element)supertype);
        if (discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY) {
            throw new ProcessingException((Element)subtype, "EXTERNAL_PROPERTY can only be used for properties. Trying to use it for classes will result in inclusion strategy of basic PROPERTY instead.");
        }
        String typeProperty = this.resolveTypeProperty(supertype).orElseThrow();
        ArrayList<String> allNames = new ArrayList<String>();
        switch (discriminatorValueKind) {
            case NAME: {
                subtype.stringValue(SerdeConfig.class, "typeName").ifPresent(allNames::add);
                for (AnnotationValue parentSubtype : supertype.getDeclaredAnnotationValuesByType(SerdeConfig.SerSubtyped.SerSubtype.class)) {
                    String parentSubtypeName = parentSubtype.stringValue().orElse(null);
                    if (!subtype.getName().equals(parentSubtypeName)) continue;
                    parentSubtype.stringValue("name").ifPresent(allNames::add);
                    Collections.addAll(allNames, parentSubtype.stringValues("names"));
                }
                if (!allNames.isEmpty()) break;
                allNames.add(subtype.getSimpleName());
                break;
            }
            case CLASS_SIMPLE_NAME: {
                allNames.add(subtype.getSimpleName());
                break;
            }
            case MINIMAL_CLASS: {
                String superPackage = supertype.getPackage().getName();
                String name = subtype.getName();
                String typeName = name.startsWith(superPackage) ? name.substring(superPackage.length()) : name;
                allNames.add(typeName);
                break;
            }
            default: {
                allNames.add(subtype.getName());
            }
        }
        subtype.annotate(SerdeConfig.class, builder -> {
            builder.member("typeName", (String)allNames.get(0));
            builder.member("typeNames", allNames.toArray(new String[0]));
            switch (discriminatorType) {
                case WRAPPER_OBJECT: {
                    builder.member("wrapperProperty", (String)allNames.get(0));
                    break;
                }
                case WRAPPER_ARRAY: {
                    builder.member("arrayWrapperProperty", (String)allNames.get(0));
                    break;
                }
                case PROPERTY: {
                    builder.member("typeProperty", typeProperty);
                    break;
                }
                case EXISTING_PROPERTY: {
                    builder.member("typeDiscriminatorType", (Enum)discriminatorType);
                }
            }
            if (supertype.booleanValue(SerdeConfig.SerSubtyped.class, "discriminatorVisible").orElse(false).booleanValue()) {
                builder.member("typePropertyVisible", true);
            }
        });
    }

    private void visitClassInternal(ClassElement element, VisitorContext context, boolean isImport) {
        this.visitClassSubtypes(element, context);
        if (element.hasDeclaredAnnotation(SerdeImport.Repeated.class) && !isImport) {
            List values = element.getDeclaredAnnotationValuesByType(SerdeImport.class);
            ArrayList classValues = new ArrayList();
            for (AnnotationValue value : values) {
                value.annotationClassValue("value").flatMap(acv -> context.getClassElement(acv.getName())).ifPresent(c -> {
                    if (!c.isPublic()) {
                        throw new ProcessingException((Element)element, "Cannot mixin non-public type: " + c.getName());
                    }
                    this.handleClassImport(context, (AnnotationValue<SerdeImport>)value, (ClassElement)c, classValues);
                });
                value.stringValue("packageName").ifPresent(packageName -> {
                    ClassElement[] classElements;
                    for (ClassElement c : classElements = context.getClassElements(packageName, new String[]{"*"})) {
                        if (!c.isPublic()) continue;
                        this.handleClassImport(context, (AnnotationValue<SerdeImport>)value, c, classValues);
                    }
                });
            }
            element.annotate(Introspected.class, builder -> builder.member("classes", classValues.toArray(new AnnotationClassValue[0])));
        } else if (this.isJsonAnnotated(element) || isImport) {
            MethodElement primaryConstructor;
            if (!(element.hasStereotype(Serdeable.Serializable.class) || element.hasStereotype(Serdeable.Deserializable.class) || isImport)) {
                element.annotate(Serdeable.class);
                element.annotate(Introspected.class, i -> {
                    i.member("accessKind", new Enum[]{Introspected.AccessKind.METHOD, Introspected.AccessKind.FIELD});
                    i.member("visibility", "PUBLIC");
                });
            }
            AnnotationValue declaredAnnotation = element.getDeclaredAnnotation(SerdeConfig.class);
            if (this.failOnError && declaredAnnotation != null) {
                ClassElement thatType;
                ClassElement thatType2;
                String serializeAs = declaredAnnotation.stringValue("serAs").orElse(null);
                if (serializeAs != null && (thatType2 = (ClassElement)context.getClassElement(serializeAs).orElse(null)) != null && !thatType2.isAssignable(element) && this.failOnError) {
                    throw new ProcessingException((Element)element, "Type to serialize as [" + serializeAs + "], must be a subtype of the annotated type: " + element.getName());
                }
                String deserializeAs = declaredAnnotation.stringValue("deserAs").orElse(null);
                if (deserializeAs != null && (thatType = (ClassElement)context.getClassElement(deserializeAs).orElse(null)) != null && !thatType.isAssignable(element) && this.failOnError) {
                    throw new ProcessingException((Element)element, "Type to deserialize as [" + deserializeAs + "], must be a subtype of the annotated type: " + element.getName());
                }
            }
            if ((primaryConstructor = (MethodElement)element.getPrimaryConstructor().orElse(null)) != null) {
                this.creatorMode = primaryConstructor.enumValue(Creator.class, "mode", SerdeConfig.SerCreatorMode.class).orElse(null);
                if (this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING && this.failOnError && primaryConstructor.getParameters().length != 1) {
                    throw new ProcessingException((Element)element, "DELEGATING creator mode requires exactly one Creator parameter, but more were defined.");
                }
            }
            this.visitProperties(element, context);
            this.findTypeInfo(element, false).ifPresent(superType -> this.visitSubtype((ClassElement)superType, element, context));
            if (this.failOnError && element.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class) && this.creatorMode == SerdeConfig.SerCreatorMode.DELEGATING) {
                throw new ProcessingException((Element)element, "Inheritance cannot be combined with DELEGATING creation");
            }
        }
    }

    private void visitProperties(ClassElement classElement, VisitorContext context) {
        List beanProperties = classElement.getBeanProperties();
        List<String> order = Arrays.asList(classElement.stringValues("PropertyOrder"));
        Collections.reverse(order);
        Set access = CollectionUtils.setOf((Object[])((Introspected.AccessKind[])classElement.enumValues(Introspected.class, "accessKind", Introspected.AccessKind.class)));
        boolean supportFields = access.contains(Introspected.AccessKind.FIELD);
        String[] ignoresProperties = classElement.stringValues(SerdeConfig.SerIgnored.class);
        String[] includeProperties = classElement.stringValues(SerdeConfig.SerIncluded.class);
        boolean ignoreOnlyDeserialization = classElement.booleanValue(SerdeConfig.SerIgnored.class, "allowSerialize").orElse(false);
        boolean ignoreOnlySerialization = classElement.booleanValue(SerdeConfig.SerIgnored.class, "allowDeserialize").orElse(false);
        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy((TypedElement)classElement, null);
        this.processProperties(context, beanProperties, order, ignoresProperties, includeProperties, ignoreOnlyDeserialization, ignoreOnlySerialization, propertyNamingStrategy);
        if (supportFields) {
            List fields = classElement.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().onlyAccessible());
            this.processProperties(context, fields, order, ignoresProperties, includeProperties, ignoreOnlyDeserialization, ignoreOnlySerialization, propertyNamingStrategy);
        }
    }

    private void handleClassImport(VisitorContext context, AnnotationValue<SerdeImport> value, ClassElement c, List<AnnotationClassValue<?>> classValues) {
        classValues.add(new AnnotationClassValue(c.getName()));
        ClassElement mixinType = value.stringValue("mixin").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(null);
        if (mixinType != null) {
            this.visitMixin(mixinType, c);
        } else {
            this.visitClassInternal(c, context, true);
        }
        c.annotate(value);
        AnnotationValue jsonPojoAnn = c.getAnnotation("com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder");
        if (jsonPojoAnn != null) {
            String buildMethod = jsonPojoAnn.stringValue("buildMethodName").orElse("build");
            c.getEnclosedElement(ElementQuery.ALL_METHODS.named(n -> n.equals(buildMethod))).ifPresent(m -> m.annotate(Executable.class));
        }
    }

    private void visitMixin(ClassElement mixinType, ClassElement type) {
        mixinType.getAnnotationNames().stream().filter(n -> n.startsWith("io.micronaut.serde")).forEach(n -> {
            AnnotationValue ann = mixinType.getAnnotation(n);
            if (ann != null) {
                type.annotate(ann);
            }
        });
        mixinType.findAnnotation(SerdeConfig.class).ifPresent(arg_0 -> ((ClassElement)type).annotate(arg_0));
        Map<String, FieldElement> serdeFields = mixinType.getEnclosedElements(ElementQuery.ALL_FIELDS.onlyInstance().onlyDeclared().annotated(ann -> ann.hasAnnotation(SerdeConfig.class))).stream().collect(Collectors.toMap(Element::getName, e -> e));
        MethodElement mixinCtor = mixinType.getPrimaryConstructor().orElse(null);
        MethodElement targetCtor = type.getPrimaryConstructor().orElse(null);
        if (mixinCtor != null && targetCtor != null) {
            if (!this.argumentsMatch(mixinCtor, targetCtor)) {
                MethodElement prevCtor = targetCtor;
                targetCtor = type.getAccessibleConstructors().stream().filter(c -> this.argumentsMatch(mixinCtor, (MethodElement)c)).findFirst().orElse(null);
                if (targetCtor != null) {
                    targetCtor.annotate(Creator.class);
                    prevCtor.removeAnnotation(Creator.class);
                }
            }
            if (targetCtor != null) {
                this.replicateAnnotations((Element)mixinCtor, (Element)targetCtor);
                ParameterElement[] mixinCtorParameters = mixinCtor.getParameters();
                ParameterElement[] targetCtorParameters = targetCtor.getParameters();
                for (int i = 0; i < mixinCtorParameters.length; ++i) {
                    ParameterElement mixinCtorParameter = mixinCtorParameters[i];
                    ParameterElement targetCtorParameter = targetCtorParameters[i];
                    this.replicateAnnotations((Element)mixinCtorParameter, (Element)targetCtorParameter);
                }
            }
        }
        ArrayList serdeMethods = mixinType.isRecord() ? Collections.emptyList() : new ArrayList(mixinType.getEnclosedElements(ElementQuery.ALL_METHODS.onlyInstance().onlyDeclared().annotated(ann -> ann.getAnnotationNames().stream().anyMatch(n -> n.startsWith("io.micronaut.serde.config.annotation")))));
        List beanProperties = type.getBeanProperties();
        for (PropertyElement beanProperty : beanProperties) {
            FieldElement f = serdeFields.get(beanProperty.getName());
            if (f != null && f.getType().equals(beanProperty.getType())) {
                this.replicateAnnotations((Element)f, (Element)beanProperty);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(serdeMethods)) continue;
            MethodElement readMethod = beanProperty.getReadMethod().orElse(null);
            MethodElement writeMethod = beanProperty.getWriteMethod().orElse(null);
            Iterator i = serdeMethods.iterator();
            while (i.hasNext()) {
                MethodElement serdeMethod = (MethodElement)i.next();
                if (readMethod != null && serdeMethod.getName().equals(readMethod.getName()) && this.argumentsMatch(serdeMethod, readMethod)) {
                    i.remove();
                    this.replicateAnnotations((Element)serdeMethod, (Element)beanProperty);
                    this.replicateAnnotations((Element)serdeMethod, (Element)readMethod);
                }
                if (writeMethod == null || !serdeMethod.getName().equals(writeMethod.getName()) || !this.argumentsMatch(serdeMethod, writeMethod)) continue;
                i.remove();
                this.replicateAnnotations((Element)serdeMethod, (Element)beanProperty);
                this.replicateAnnotations((Element)serdeMethod, (Element)writeMethod);
            }
        }
        if (!serdeMethods.isEmpty()) {
            for (MethodElement serdeMethod : serdeMethods) {
                type.getEnclosedElement(ElementQuery.ALL_METHODS.onlyInstance().onlyAccessible().named(n -> n.equals(serdeMethod.getName())).filter(left -> left.getReturnType().equals(serdeMethod.getReturnType()) && this.argumentsMatch((MethodElement)left, serdeMethod))).ifPresent(m -> {
                    m.annotate(Executable.class);
                    this.replicateAnnotations((Element)serdeMethod, (Element)m);
                });
            }
        }
    }

    private boolean argumentsMatch(MethodElement left, MethodElement right) {
        ParameterElement[] rp;
        ParameterElement[] lp = left.getParameters();
        if (lp.length == (rp = right.getParameters()).length) {
            if (lp.length == 0) {
                return true;
            }
            for (int i = 0; i < lp.length; ++i) {
                ParameterElement p1 = lp[i];
                ParameterElement p2 = rp[i];
                if (p1.getType().equals(p2.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void replicateAnnotations(Element source, Element target) {
        Set annotationNames = source.getAnnotationNames();
        for (String annotationName : annotationNames) {
            AnnotationValue config = source.getAnnotation(annotationName);
            if (config == null) continue;
            target.annotate(config);
        }
    }

    @Nullable
    private PropertyNamingStrategy getPropertyNamingStrategy(@NonNull TypedElement element, @Nullable PropertyNamingStrategy defaultValue) {
        String namingStrategy = element.stringValue(SerdeConfig.class, "naming").filter(val -> !val.equals(PropertyNamingStrategy.IDENTITY.getClass().getName())).orElse(null);
        if (namingStrategy != null) {
            PropertyNamingStrategy propertyNamingStrategy = PropertyNamingStrategy.forName((String)namingStrategy).orElse(null);
            if (propertyNamingStrategy == null) {
                Object o = InstantiationUtils.tryInstantiate((String)namingStrategy, (ClassLoader)this.getClass().getClassLoader()).orElse(null);
                if (o instanceof PropertyNamingStrategy) {
                    return o;
                }
                element.annotate(SerdeConfig.class, builder -> builder.member("runtimeNaming", namingStrategy));
            }
            return propertyNamingStrategy;
        }
        return defaultValue;
    }

    private void processProperties(VisitorContext context, List<? extends TypedElement> beanProperties, List<String> orderDef, String[] ignoresProperties, String[] includeProperties, boolean ignoreOnlyDeserialization, boolean ignoreOnlySerialization, @Nullable PropertyNamingStrategy namingStrategy) {
        Set ignoredSet = CollectionUtils.setOf((Object[])ignoresProperties);
        Set includeSet = CollectionUtils.setOf((Object[])includeProperties);
        ArrayList<String> order = new ArrayList<String>(orderDef);
        for (TypedElement typedElement : beanProperties) {
            this.checkForErrors((Element)typedElement, context);
            PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(typedElement, namingStrategy);
            if (typedElement instanceof PropertyElement) {
                PropertyElement pm = (PropertyElement)typedElement;
                pm.getReadMethod().ifPresent(this.readMethods::add);
                pm.getWriteMethod().ifPresent(this.writeMethods::add);
            }
            if (!typedElement.isPrimitive() && !typedElement.isArray()) {
                ClassElement t = typedElement.getGenericType();
                this.handleJsonIgnoreType(context, typedElement, t);
            }
            String propertyName = this.resolvePropertyName(typedElement);
            if (propertyNamingStrategy != null) {
                typedElement.annotate(SerdeConfig.class, builder -> builder.member("property", propertyNamingStrategy.translate((AnnotatedElement)beanProperty)));
            }
            if (CollectionUtils.isNotEmpty(order)) {
                int index = order.indexOf(propertyName);
                if (index == -1) {
                    index = order.indexOf(typedElement.getName());
                }
                if (index > -1) {
                    order.set(index, "");
                    int finalIndex = index;
                    typedElement.annotate(Order.class, builder -> builder.value(-(finalIndex + 1)));
                }
            }
            if (ignoredSet.contains(propertyName)) {
                this.ignoreProperty(ignoreOnlyDeserialization, ignoreOnlySerialization, typedElement);
                continue;
            }
            if (includeSet.isEmpty() || includeSet.contains(propertyName)) continue;
            this.ignoreProperty(false, false, typedElement);
        }
    }

    private void ignoreProperty(boolean ignoreOnlyDeserialization, boolean ignoreOnlySerialization, TypedElement beanProperty) {
        if (beanProperty instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)beanProperty;
            if (ignoreOnlySerialization) {
                propertyElement.getReadMethod().ifPresent(e -> e.annotate(SerdeConfig.class, builder -> builder.member("ignoredSerialization", true)));
            } else if (ignoreOnlyDeserialization) {
                propertyElement.getWriteMethod().ifPresent(e -> e.annotate(SerdeConfig.class, builder -> builder.member("ignoredDeserialization", true)));
            } else {
                propertyElement.annotate(SerdeConfig.class, builder -> builder.member("ignored", true));
            }
        } else if (ignoreOnlySerialization) {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignoredSerialization", true));
        } else if (ignoreOnlyDeserialization) {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignoredDeserialization", true));
        } else {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignored", true));
        }
    }

    private void handleJsonIgnoreType(VisitorContext context, TypedElement beanProperty, ClassElement t) {
        boolean ignoredType;
        String typeName = t.getName();
        if (!ClassUtils.isJavaBasicType((String)typeName) && (ignoredType = context.getClassElement(typeName).map(c -> c.hasAnnotation(SerdeConfig.SerIgnored.SerType.class)).orElse(false).booleanValue())) {
            beanProperty.annotate(SerdeConfig.class, builder -> builder.member("ignored", true));
        }
    }

    private void resetForNewClass(ClassElement element) {
        this.currentClass = element;
        this.failOnError = element.booleanValue(SerdeConfig.class, "validate").or(() -> element.booleanValue(Serdeable.class, "validate")).orElse(true);
        this.creatorMode = SerdeConfig.SerCreatorMode.PROPERTIES;
        this.anyGetterMethod = null;
        this.anySetterMethod = null;
        this.anyGetterField = null;
        this.anySetterField = null;
        this.jsonValueField = null;
        this.jsonValueMethod = null;
        this.readMethods.clear();
        this.writeMethods.clear();
    }

    private SerdeConfig.SerSubtyped.DiscriminatorValueKind getDiscriminatorValueKind(Element typeInfo) {
        return typeInfo.enumValue(SerdeConfig.SerSubtyped.class, "dv", SerdeConfig.SerSubtyped.DiscriminatorValueKind.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME);
    }

    private Optional<ClassElement> findTypeInfo(ClassElement element, boolean includeElement) {
        if (element.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class) && includeElement) {
            return Optional.of(element);
        }
        ClassElement superElement = element.getSuperType().orElse(null);
        if (superElement == null) {
            ClassElement itfe = this.findInDeclaredInterfaces(element);
            if (itfe != null) {
                return Optional.of(itfe);
            }
            return Optional.empty();
        }
        if (superElement.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class)) {
            return Optional.of(superElement);
        }
        ClassElement itfe = this.findInDeclaredInterfaces(element);
        if (itfe == null) {
            itfe = this.findInDeclaredInterfaces(superElement);
        }
        if (itfe != null) {
            return Optional.of(itfe);
        }
        return this.findTypeInfo(superElement, true);
    }

    private ClassElement findInDeclaredInterfaces(@NonNull ClassElement superElement) {
        Collection interfaces = superElement.getInterfaces();
        if (CollectionUtils.isNotEmpty((Collection)interfaces)) {
            for (ClassElement anInterface : interfaces) {
                if (anInterface.hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class)) {
                    return anInterface;
                }
                ClassElement e = this.findInDeclaredInterfaces(anInterface);
                if (e == null) continue;
                return e;
            }
        }
        return null;
    }

    private Optional<String> resolveTypeProperty(@NonNull ClassElement superType) {
        ClassElement typeInfo = this.findTypeInfo(superType, true).orElse(null);
        if (typeInfo != null) {
            return typeInfo.stringValue(SerdeConfig.SerSubtyped.class, "dp");
        }
        return Optional.empty();
    }

    private SerdeConfig.SerSubtyped.DiscriminatorType getDiscriminatorType(Element element) {
        return element.enumValue(SerdeConfig.SerSubtyped.class, "dt", SerdeConfig.SerSubtyped.DiscriminatorType.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY);
    }

    public int getOrder() {
        return 0;
    }

    private boolean isJsonAnnotated(ClassElement element) {
        return Stream.of("com.fasterxml.jackson.annotation.JsonClassDescription", "com.fasterxml.jackson.databind.annotation.JsonNaming", "com.fasterxml.jackson.databind.annotation.JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonDeserialize", "com.fasterxml.jackson.annotation.JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonRootName", "com.fasterxml.jackson.annotation.JsonTypeName", "com.fasterxml.jackson.annotation.JsonTypeId", "com.fasterxml.jackson.annotation.JsonAutoDetect", "com.fasterxml.jackson.annotation.JsonIgnoreProperties", "com.fasterxml.jackson.annotation.JsonIncludeProperties").anyMatch(arg_0 -> ((ClassElement)element).hasDeclaredAnnotation(arg_0)) || element.hasStereotype(Serdeable.Serializable.class) || element.hasStereotype(Serdeable.Deserializable.class);
    }

    private static boolean isBasicType(ClassElement propertyType) {
        if (propertyType == null) {
            return false;
        }
        String name = propertyType.getName();
        return ClassUtils.isJavaBasicType((String)name) || propertyType.isPrimitive() && !propertyType.isArray();
    }

    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    private static /* synthetic */ boolean lambda$resolvePropertyNames$9(Set ignoreSet, Set includeSet, String s) {
        return !(ignoreSet != null && ignoreSet.contains(s) || includeSet != null && !includeSet.contains(s));
    }
}

