/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import java.util.Map;
import java.util.Objects;

@Internal
final class DeserBeanKey {
    private final SerdeConfiguration serdeConfiguration;
    private final DeserializationConfiguration deserializationConfiguration;
    private final Argument<?> type;
    @Nullable
    private final Map<String, Argument<?>> typeArguments;
    @Nullable
    private final SerdeArgumentConf serdeArgumentConf;
    private final int hashCode;

    public DeserBeanKey(SerdeConfiguration serdeConfiguration, DeserializationConfiguration deserializationConfiguration, @NonNull Argument<?> type, @Nullable Map<String, Argument<?>> typeArguments, @Nullable SerdeArgumentConf serdeArgumentConf) {
        this.serdeConfiguration = serdeConfiguration;
        this.deserializationConfiguration = deserializationConfiguration;
        this.type = type;
        this.typeArguments = typeArguments;
        this.serdeArgumentConf = serdeArgumentConf;
        this.hashCode = type.typeHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeserBeanKey that = (DeserBeanKey)o;
        return this.type.equalsType(that.type) && Objects.equals(this.typeArguments, that.typeArguments) && Objects.equals(this.serdeArgumentConf, that.serdeArgumentConf) && this.deserializationConfiguration == that.deserializationConfiguration && this.serdeConfiguration == that.serdeConfiguration;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NonNull
    public Argument<?> getType() {
        return this.type;
    }
}

