/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.support.deserializers.DeserializerSubtypeInfo;
import java.io.IOException;

@Internal
final class SubtypedExternalPropertyObjectDeserializer
implements Deserializer<Object> {
    private final DeserializerSubtypeInfo<? super Object> subtypeInfo;

    SubtypedExternalPropertyObjectDeserializer(DeserializerSubtypeInfo<? super Object> subtypeInfo) {
        this.subtypeInfo = subtypeInfo;
    }

    static PropertyReference<Object, String> createExternalPropertyReference(Deserializer.DecoderContext decoderContext, String discriminator, String value) {
        String referenceName = "externalProperty@" + discriminator;
        return decoderContext.resolveReference(new PropertyReference(referenceName, null, Argument.of(String.class, (String)referenceName), (Object)value));
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        PropertyReference<Object, String> externalPropertyReference = SubtypedExternalPropertyObjectDeserializer.createExternalPropertyReference(decoderContext, this.subtypeInfo.parent().info().discriminatorName(), null);
        PropertyReference ref = decoderContext.resolveReference(externalPropertyReference);
        String discriminatorValue = (String)ref.getReference();
        Deserializer<? super Object> deserializer = this.subtypeInfo.findDeserializer(discriminatorValue);
        return deserializer.deserialize(decoder, decoderContext, type);
    }
}

