/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.InstantSerde;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;

@Internal
final class DateSerde
implements SerdeRegistrar<Date> {
    private static final Argument<Instant> INSTANT_ARGUMENT = Argument.of(Instant.class);
    private final InstantSerde instantSerde;

    DateSerde(InstantSerde instantSerde) {
        this.instantSerde = instantSerde;
    }

    public Serializer<Date> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Date> type) {
        final Argument argument = Argument.of(Instant.class, (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])new Argument[0]);
        final Serializer specific = this.instantSerde.createSpecific(encoderContext, argument);
        if (specific != this.instantSerde) {
            return new Serializer<Date>(){

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Date> t, Date value) throws IOException {
                    specific.serialize(encoder, context, argument, (Object)value.toInstant());
                }

                public boolean isDefault(Serializer.EncoderContext context, Date value) {
                    return value.getTime() == 0L;
                }
            };
        }
        return this;
    }

    public Deserializer<Date> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Date> context) throws SerdeException {
        Argument argument = Argument.of(Instant.class, (AnnotationMetadata)context.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Deserializer specific = this.instantSerde.createSpecific(decoderContext, argument);
        if (specific != this.instantSerde) {
            return (decoder, subContext, type) -> {
                Instant i = (Instant)specific.deserialize(decoder, subContext, argument);
                if (i != null) {
                    return Date.from(i);
                }
                return null;
            };
        }
        return this;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Date> type, Date value) throws IOException {
        this.instantSerde.serialize(encoder, context, INSTANT_ARGUMENT, value.toInstant());
    }

    public Date deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Date> type) throws IOException {
        return Date.from((Instant)this.instantSerde.deserialize(decoder, decoderContext, (Argument)INSTANT_ARGUMENT));
    }

    public boolean isDefault(Serializer.EncoderContext context, Date value) {
        return value.getTime() == 0L;
    }

    @Override
    public Argument<Date> getType() {
        return Argument.of(Date.class);
    }
}

