/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.serdes.EnumSerde;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

final class EnumValueDeserializer<E extends Enum<E>>
implements Deserializer<E> {
    private final Argument<Object> valueType;
    private final Deserializer<?> valueDeserializer;
    private final boolean allowNull;
    private final Map<Object, E> cache;
    private final boolean acceptCaseInsensitive;

    EnumValueDeserializer(Argument<Object> valueType, Deserializer<?> valueDeserializer, boolean allowNull, Map<Object, E> cache, boolean acceptCaseInsensitive) {
        this.valueType = valueType;
        this.valueDeserializer = valueDeserializer;
        this.allowNull = allowNull;
        this.cache = cache;
        this.acceptCaseInsensitive = acceptCaseInsensitive;
    }

    @NonNull
    private E transform(@NonNull Decoder decoder, Object value) throws IOException {
        Enum enumValue = (Enum)this.cache.get(value);
        if (enumValue != null) {
            return (E)enumValue;
        }
        if (this.acceptCaseInsensitive) {
            Map.Entry<Object, E> e;
            Object object;
            Iterator<Map.Entry<Object, E>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext() && (object = (e = iterator.next()).getKey()) instanceof String) {
                String key = (String)object;
                if (!(value instanceof String)) break;
                String val = (String)value;
                if (!key.equalsIgnoreCase(val)) continue;
                return (E)((Enum)e.getValue());
            }
        }
        throw EnumSerde.failedToDeserialize(decoder, this.cache, value);
    }

    public E deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        return this.transform(decoder, this.valueDeserializer.deserialize(decoder, context, this.valueType));
    }

    public E deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) throws IOException {
        Object v = this.valueDeserializer.deserializeNullable(decoder, context, this.valueType);
        if (!this.allowNull && v == null) {
            return null;
        }
        return this.transform(decoder, v);
    }
}

