/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SpreadProcessor<T, R>
implements Processor<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(SpreadProcessor.class);
    private volatile Subscription upstreamSubscription;
    private volatile Subscriber<? super R> downstreamSubscriber;
    private volatile boolean cancelled = false;
    private Throwable upstreamError = null;
    private volatile boolean upstreamComplete = false;
    private final AtomicLong demand = new AtomicLong();
    private int upstreamRequested = 0;
    private final AtomicInteger wip = new AtomicInteger();
    private final Queue<T> inboundQueue = new ArrayDeque<T>();
    private final Queue<R> outboundQueue = new ArrayDeque<R>();
    private boolean completedProcessing = false;

    SpreadProcessor() {
    }

    public void subscribe(Subscriber<? super R> s) {
        this.downstreamSubscriber = s;
        this.downstreamSubscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Registering new demand: {}", (Object)n);
                }
                SpreadProcessor.this.demand.updateAndGet(l -> l + n < l ? Long.MAX_VALUE : l + n);
                SpreadProcessor.this.work();
            }

            public void cancel() {
                SpreadProcessor.this.cancelled = true;
                SpreadProcessor.this.work();
            }
        });
        this.work();
    }

    public final void onSubscribe(Subscription s) {
        this.upstreamSubscription = s;
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNext(T t) {
        Queue<T> queue = this.inboundQueue;
        synchronized (queue) {
            this.inboundQueue.offer(t);
        }
        this.work();
    }

    public final void onError(Throwable t) {
        this.upstreamError = t;
        this.upstreamComplete = true;
        this.work();
    }

    public final void onComplete() {
        this.upstreamError = null;
        this.upstreamComplete = true;
        this.work();
    }

    private void work() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        do {
            this.workImpl();
        } while (this.wip.decrementAndGet() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workImpl() {
        if (this.cancelled && this.upstreamSubscription != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cancelling upstream subscription");
            }
            this.upstreamSubscription.cancel();
            this.upstreamSubscription = null;
        }
        boolean upstreamComplete = this.upstreamComplete;
        while (this.demand.get() != 0L && !this.cancelled) {
            R toForward = this.outboundQueue.poll();
            if (toForward == null) {
                T toProcess;
                Queue<T> queue = this.inboundQueue;
                synchronized (queue) {
                    toProcess = this.inboundQueue.poll();
                }
                if (toProcess == null) {
                    if (upstreamComplete) {
                        if (this.completedProcessing) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("No more data, completing downstream");
                            }
                            if (this.upstreamError == null) {
                                this.downstreamSubscriber.onComplete();
                                break;
                            }
                            this.downstreamSubscriber.onError(this.upstreamError);
                            break;
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("No more data from upstream, completing processing");
                        }
                        try {
                            this.complete(this.outboundQueue);
                            this.completedProcessing = true;
                        }
                        catch (Exception e) {
                            this.cancelled = true;
                            this.downstreamSubscriber.onError((Throwable)e);
                        }
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Completing done, {} items created", (Object)this.outboundQueue.size());
                        continue;
                    }
                    if (this.upstreamRequested != 0 || this.upstreamSubscription == null) break;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No more data available, requesting more from upstream");
                    }
                    ++this.upstreamRequested;
                    this.upstreamSubscription.request(1L);
                    break;
                }
                --this.upstreamRequested;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Spreading an item: {}", toProcess);
                }
                try {
                    this.spread(toProcess, this.outboundQueue);
                }
                catch (Exception e) {
                    this.cancelled = true;
                    this.downstreamSubscriber.onError((Throwable)e);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Spreading done, {} items created", (Object)this.outboundQueue.size());
                continue;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Forwarding an item: {}", toForward);
            }
            this.downstreamSubscriber.onNext(toForward);
            this.demand.decrementAndGet();
        }
    }

    protected abstract void spread(T var1, Collection<R> var2) throws Exception;

    protected void complete(Collection<R> out) throws Exception {
    }
}

