/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.buildtools;

public final class MavenDependency {
    private final String group;
    private final String artifact;
    private final String version;

    public MavenDependency(String group, String artifact, String version) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenDependency that = (MavenDependency)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.artifact.equals(that.artifact)) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public String getModule() {
        return this.getGroup() + ":" + this.getArtifact();
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.artifact.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getModule() + (String)(this.version == null ? "" : ":" + this.version);
    }
}

