/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.annotation.InList;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;

@Singleton
public class InListValidator
implements ConstraintValidator<InList, Object> {
    @Override
    public boolean isValid(@Nullable Object value, @NonNull AnnotationValue<InList> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        String[] listValues;
        if (value == null) {
            return true;
        }
        if (!(value instanceof String) && !(value instanceof Enum)) {
            return true;
        }
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        if ((listValues = annotationMetadata.stringValues("value")).length == 0) {
            return true;
        }
        boolean caseSensitive = annotationMetadata.booleanValue("caseSensitive").orElse(true);
        String stringValue = (String)value;
        for (String listValue : listValues) {
            if (!(caseSensitive ? stringValue.equals(listValue) : stringValue.equalsIgnoreCase(listValue))) continue;
            return true;
        }
        return false;
    }
}

