/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.annotation.UniqueElements;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.StreamSupport;

@Singleton
public class UniqueElementsValidator
implements ConstraintValidator<UniqueElements, Object> {
    @Override
    public boolean isValid(@Nullable Object value, @NonNull AnnotationValue<UniqueElements> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        HashSet<Object> seen = new HashSet<Object>();
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            return StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).allMatch(seen::add);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                if (element == null || seen.add(element)) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

