/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.messages;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.validation.validator.messages.DefaultMessageInterpolatorContext;
import io.micronaut.validation.validator.messages.InterpolatorLocaleResolver;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.MessageInterpolator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;

@Singleton
public class DefaultMessageInterpolator
implements MessageInterpolator {
    private static final char QUOT = '\\';
    private static final char L_BRACE = '{';
    private static final char R_BRACE = '}';
    private static final char DOLL_BRACE = '$';
    @Nullable
    private final InterpolatorLocaleResolver interpolatorLocaleResolver;
    private final MessageSource messageSource;

    @Inject
    public DefaultMessageInterpolator(MessageSource messageSource, @Nullable InterpolatorLocaleResolver interpolatorLocaleResolver) {
        this.messageSource = messageSource;
        this.interpolatorLocaleResolver = interpolatorLocaleResolver;
    }

    @Deprecated(forRemoval=true, since="4.9.0")
    public DefaultMessageInterpolator(MessageSource messageSource) {
        this(messageSource, Optional::empty);
    }

    private String interpolate(@NonNull String template, @NonNull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull((String)"template", (Object)template);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder variableBuilder = new StringBuilder();
        StringBuilder builder = messageBuilder;
        boolean isVariable = false;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '\\' && i + 1 < template.length()) {
                if ((c = template.charAt(++i)) == '{') {
                    builder.append('{');
                    continue;
                }
                if (c == '}') {
                    builder.append('}');
                    continue;
                }
                if (c == '$') {
                    builder.append('$');
                    continue;
                }
                builder.append('\\');
                builder.append(c);
                continue;
            }
            if (c == '{') {
                if (!isVariable) {
                    isVariable = true;
                    builder = variableBuilder;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '}') {
                if (isVariable) {
                    builder = messageBuilder;
                    isVariable = false;
                    String variableName = variableBuilder.toString();
                    variableBuilder.setLength(0);
                    Object variableValue = context.getVariables().get(variableName);
                    if (variableValue == null) {
                        variableValue = this.messageSource.getMessage(variableName, context).orElse(null);
                    }
                    if (variableValue == null) {
                        builder.append('{').append(variableName).append('}');
                        continue;
                    }
                    builder.append(variableValue);
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        Locale locale = this.interpolatorLocaleResolver != null ? this.interpolatorLocaleResolver.resolve().orElseGet(Locale::getDefault) : Locale.getDefault();
        return this.interpolate(messageTemplate, context, locale);
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(context.getConstraintDescriptor().getAttributes());
        attributes.put("validatedValue", context.getValidatedValue());
        if (context instanceof DefaultMessageInterpolatorContext) {
            DefaultMessageInterpolatorContext interpolatorContext = (DefaultMessageInterpolatorContext)context;
            attributes.put("validatedPath", interpolatorContext.getValidatorContext().getCurrentPath());
        }
        return this.interpolate(messageTemplate, MessageSource.MessageContext.of((Locale)locale, attributes));
    }
}

