/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.streaming.ConnectionLostHandler;
import io.nats.streaming.NatsStreaming;
import io.nats.streaming.SubscriptionOptions;
import java.io.Serializable;
import java.time.Duration;

public class Options {
    private final String natsUrl;
    private final Connection natsConn;
    private Duration connectTimeout;
    private final Duration ackTimeout;
    private final String discoverPrefix;
    private final int maxPubAcksInFlight;
    private final ErrorListener errorListener;
    private final ConnectionListener connectionListener;
    private final ConnectionLostHandler lostHandler;
    private final Duration pingInterval;
    private final int pingsMaxOut;
    private final String clientId;
    private final String clusterId;
    private final boolean traceConnection;

    private Options(Builder builder) {
        this.natsUrl = builder.natsUrl;
        this.natsConn = builder.natsConn;
        this.connectTimeout = builder.connectTimeout;
        this.ackTimeout = builder.ackTimeout;
        this.discoverPrefix = builder.discoverPrefix;
        this.maxPubAcksInFlight = builder.maxPubAcksInFlight;
        this.connectionListener = builder.connectionListener;
        this.errorListener = builder.errorListener;
        this.clientId = builder.clientId;
        this.clusterId = builder.clusterId;
        this.lostHandler = builder.lostHandler;
        this.pingInterval = builder.pingInterval;
        this.pingsMaxOut = builder.pingsMaxOut;
        this.traceConnection = builder.traceConnection;
    }

    String getClientId() {
        return this.clientId;
    }

    String getClusterId() {
        return this.clusterId;
    }

    String getNatsUrl() {
        return this.natsUrl;
    }

    ErrorListener getErrorListener() {
        return this.errorListener;
    }

    ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    ConnectionLostHandler getConnectionLostHandler() {
        return this.lostHandler;
    }

    Connection getNatsConn() {
        return this.natsConn;
    }

    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    Duration getAckTimeout() {
        return this.ackTimeout;
    }

    String getDiscoverPrefix() {
        return this.discoverPrefix;
    }

    int getMaxPubAcksInFlight() {
        return this.maxPubAcksInFlight;
    }

    Duration getPingInterval() {
        return this.pingInterval;
    }

    int getMaxPingsOut() {
        return this.pingsMaxOut;
    }

    public boolean isTraceConnection() {
        return this.traceConnection;
    }

    public static final class Builder
    implements Serializable {
        private static final long serialVersionUID = 4774214916207501660L;
        private String natsUrl = "nats://localhost:4222";
        private transient Connection natsConn;
        private Duration connectTimeout = Duration.ofSeconds(5L);
        private Duration ackTimeout = SubscriptionOptions.DEFAULT_ACK_WAIT;
        private String discoverPrefix = "_STAN.discover";
        private int maxPubAcksInFlight = 16384;
        private ErrorListener errorListener;
        private ConnectionListener connectionListener;
        private String clientId;
        private String clusterId;
        private ConnectionLostHandler lostHandler;
        private Duration pingInterval;
        private int pingsMaxOut;
        private boolean traceConnection;

        public Builder() {
            this.pubAckWait(SubscriptionOptions.DEFAULT_ACK_WAIT).connectWait(Duration.ofSeconds(5L)).discoverPrefix("_STAN.discover").maxPubAcksInFlight(16384).natsUrl("nats://localhost:4222").maxPingsOut(3).pingInterval(NatsStreaming.DEFAULT_PING_INTERVAL);
        }

        public Builder(Options template) {
            this.natsUrl = template.natsUrl;
            this.natsConn = template.natsConn;
            this.connectTimeout = template.connectTimeout;
            this.ackTimeout = template.ackTimeout;
            this.discoverPrefix = template.discoverPrefix;
            this.maxPubAcksInFlight = template.maxPubAcksInFlight;
            this.connectionListener = template.connectionListener;
            this.errorListener = template.errorListener;
            this.clientId = template.clientId;
            this.clusterId = template.clusterId;
            this.pingsMaxOut = template.pingsMaxOut;
            this.pingInterval = template.pingInterval;
            this.lostHandler = template.lostHandler;
            this.traceConnection = template.traceConnection;
        }

        public Builder clusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("stan: cluster ID must be non-null");
            }
            this.clusterId = clusterId;
            return this;
        }

        public String getClusterID() {
            return this.clusterId;
        }

        public Builder clientId(String clientId) {
            if (clientId == null) {
                throw new NullPointerException("stan: client ID must be non-null");
            }
            this.clientId = clientId;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public Builder errorListener(ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder connectionListener(ConnectionListener listener) {
            this.connectionListener = listener;
            return this;
        }

        public Builder connectionLostHandler(ConnectionLostHandler handler) {
            this.lostHandler = handler;
            return this;
        }

        public Builder pubAckWait(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        public Builder connectWait(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder discoverPrefix(String discoverPrefix) {
            if (discoverPrefix == null) {
                throw new NullPointerException("stan: discoverPrefix must be non-null");
            }
            this.discoverPrefix = discoverPrefix;
            return this;
        }

        public Builder maxPubAcksInFlight(int maxPubAcksInFlight) {
            if (maxPubAcksInFlight < 0) {
                throw new IllegalArgumentException("stan: max publish acks in flight must be >= 0");
            }
            this.maxPubAcksInFlight = maxPubAcksInFlight;
            return this;
        }

        public Builder natsConn(Connection natsConn) {
            this.natsConn = natsConn;
            return this;
        }

        public Builder natsUrl(String natsUrl) {
            if (natsUrl == null || natsUrl.isEmpty()) {
                throw new NullPointerException("stan: NATS URL must be non-null and not empty");
            }
            this.natsUrl = natsUrl;
            return this;
        }

        public Builder maxPingsOut(int max) {
            this.pingsMaxOut = max;
            return this;
        }

        public Builder pingInterval(Duration interval) {
            this.pingInterval = interval;
            return this;
        }

        public Options build() {
            return new Options(this);
        }

        String getNatsUrl() {
            return this.natsUrl;
        }

        ErrorListener getErrorListener() {
            return this.errorListener;
        }

        ConnectionListener getConnectionListener() {
            return this.connectionListener;
        }

        Connection getNatsConn() {
            return this.natsConn;
        }

        Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        Duration getAckTimeout() {
            return this.ackTimeout;
        }

        String getDiscoverPrefix() {
            return this.discoverPrefix;
        }

        int getMaxPubAcksInFlight() {
            return this.maxPubAcksInFlight;
        }

        public Builder traceConnection() {
            this.traceConnection = true;
            return this;
        }
    }
}

