/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.common.Timestamp;
import io.opencensus.metrics.data.AttachmentValue;
import io.opencensus.metrics.data.Exemplar;
import io.opencensus.metrics.export.Distribution;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Value;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.BucketBoundaries;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

abstract class MutableAggregation {
    private static final double TOLERANCE = 1.0E-6;

    private MutableAggregation() {
    }

    abstract void add(double var1, Map<String, AttachmentValue> var3, Timestamp var4);

    abstract void combine(MutableAggregation var1, double var2);

    abstract AggregationData toAggregationData();

    abstract Point toPoint(Timestamp var1);

    static final class MutableLastValueLong
    extends MutableLastValueDouble {
        private MutableLastValueLong() {
        }

        static MutableLastValueLong create() {
            return new MutableLastValueLong();
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.LastValueDataLong.create((long)Math.round(this.getLastValue()));
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create((Value)Value.longValue((long)Math.round(this.getLastValue())), (Timestamp)timestamp);
        }
    }

    static class MutableLastValueDouble
    extends MutableAggregation {
        private double lastValue = Double.NaN;
        private boolean initialized = false;

        private MutableLastValueDouble() {
        }

        static MutableLastValueDouble create() {
            return new MutableLastValueDouble();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            this.lastValue = value;
            if (!this.initialized) {
                this.initialized = true;
            }
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableLastValueDouble), (Object)"MutableLastValueDouble expected.");
            MutableLastValueDouble otherValue = (MutableLastValueDouble)other;
            this.lastValue = otherValue.initialized ? otherValue.getLastValue() : this.lastValue;
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.LastValueDataDouble.create((double)this.lastValue);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create((Value)Value.doubleValue((double)this.lastValue), (Timestamp)timestamp);
        }

        @VisibleForTesting
        double getLastValue() {
            return this.lastValue;
        }
    }

    static final class MutableDistribution
    extends MutableAggregation {
        private double sum = 0.0;
        private double mean = 0.0;
        private long count = 0L;
        private double sumOfSquaredDeviations = 0.0;
        private final BucketBoundaries bucketBoundaries;
        private final long[] bucketCounts;
        @Nullable
        private final Exemplar[] exemplars;

        private MutableDistribution(BucketBoundaries bucketBoundaries) {
            this.bucketBoundaries = bucketBoundaries;
            int buckets = bucketBoundaries.getBoundaries().size() + 1;
            this.bucketCounts = new long[buckets];
            this.exemplars = bucketBoundaries.getBoundaries().isEmpty() ? null : new Exemplar[buckets];
        }

        static MutableDistribution create(BucketBoundaries bucketBoundaries) {
            Preconditions.checkNotNull((Object)bucketBoundaries, (Object)"bucketBoundaries should not be null.");
            return new MutableDistribution(bucketBoundaries);
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            int bucket;
            this.sum += value;
            ++this.count;
            double deltaFromMean = value - this.mean;
            this.mean += deltaFromMean / (double)this.count;
            double deltaFromMean2 = value - this.mean;
            this.sumOfSquaredDeviations += deltaFromMean * deltaFromMean2;
            for (bucket = 0; bucket < this.bucketBoundaries.getBoundaries().size() && !(value < (Double)this.bucketBoundaries.getBoundaries().get(bucket)); ++bucket) {
            }
            int n = bucket;
            this.bucketCounts[n] = this.bucketCounts[n] + 1L;
            if (!attachments.isEmpty() && this.exemplars != null) {
                this.exemplars[bucket] = Exemplar.create((double)value, (Timestamp)timestamp, attachments);
            }
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableDistribution), (Object)"MutableDistribution expected.");
            if (Math.abs(1.0 - fraction) > 1.0E-6) {
                return;
            }
            MutableDistribution mutableDistribution = (MutableDistribution)other;
            Preconditions.checkArgument((boolean)this.bucketBoundaries.equals(mutableDistribution.bucketBoundaries), (Object)"Bucket boundaries should match.");
            if (this.count + mutableDistribution.count > 0L) {
                double delta = mutableDistribution.mean - this.mean;
                this.sumOfSquaredDeviations = this.sumOfSquaredDeviations + mutableDistribution.sumOfSquaredDeviations + Math.pow(delta, 2.0) * (double)this.count * (double)mutableDistribution.count / (double)(this.count + mutableDistribution.count);
            }
            this.count += mutableDistribution.count;
            this.sum += mutableDistribution.sum;
            this.mean = this.sum / (double)this.count;
            long[] bucketCounts = mutableDistribution.getBucketCounts();
            for (int i = 0; i < bucketCounts.length; ++i) {
                int n = i;
                this.bucketCounts[n] = this.bucketCounts[n] + bucketCounts[i];
            }
            Exemplar[] otherExemplars = mutableDistribution.getExemplars();
            if (this.exemplars != null && otherExemplars != null) {
                for (int i = 0; i < otherExemplars.length; ++i) {
                    Exemplar exemplar = otherExemplars[i];
                    if (exemplar == null) continue;
                    this.exemplars[i] = exemplar;
                }
            }
        }

        @Override
        AggregationData toAggregationData() {
            ArrayList<Long> boxedBucketCounts = new ArrayList<Long>();
            for (long bucketCount : this.bucketCounts) {
                boxedBucketCounts.add(bucketCount);
            }
            ArrayList<Exemplar> exemplarList = new ArrayList<Exemplar>();
            if (this.exemplars != null) {
                for (Exemplar exemplar : this.exemplars) {
                    if (exemplar == null) continue;
                    exemplarList.add(exemplar);
                }
            }
            return AggregationData.DistributionData.create((double)this.mean, (long)this.count, (double)this.sumOfSquaredDeviations, boxedBucketCounts, exemplarList);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            ArrayList<Distribution.Bucket> buckets = new ArrayList<Distribution.Bucket>();
            for (int bucket = 0; bucket < this.bucketCounts.length; ++bucket) {
                long bucketCount = this.bucketCounts[bucket];
                Exemplar exemplar = null;
                if (this.exemplars != null) {
                    exemplar = this.exemplars[bucket];
                }
                Distribution.Bucket metricBucket = exemplar != null ? Distribution.Bucket.create((long)bucketCount, (Exemplar)exemplar) : Distribution.Bucket.create((long)bucketCount);
                buckets.add(metricBucket);
            }
            Distribution.BucketOptions bucketOptions = Distribution.BucketOptions.explicitOptions((List)this.bucketBoundaries.getBoundaries());
            return Point.create((Value)Value.distributionValue((Distribution)Distribution.create((long)this.count, (double)(this.mean * (double)this.count), (double)this.sumOfSquaredDeviations, (Distribution.BucketOptions)bucketOptions, buckets)), (Timestamp)timestamp);
        }

        double getMean() {
            return this.mean;
        }

        long getCount() {
            return this.count;
        }

        double getSumOfSquaredDeviations() {
            return this.sumOfSquaredDeviations;
        }

        long[] getBucketCounts() {
            return this.bucketCounts;
        }

        BucketBoundaries getBucketBoundaries() {
            return this.bucketBoundaries;
        }

        @Nullable
        Exemplar[] getExemplars() {
            return this.exemplars;
        }
    }

    static final class MutableMean
    extends MutableAggregation {
        private double sum = 0.0;
        private long count = 0L;

        private MutableMean() {
        }

        static MutableMean create() {
            return new MutableMean();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            ++this.count;
            this.sum += value;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableMean), (Object)"MutableMean expected.");
            MutableMean mutableMean = (MutableMean)other;
            this.count += Math.round((double)mutableMean.count * fraction);
            this.sum += mutableMean.sum * fraction;
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.MeanData.create((double)this.getMean(), (long)this.count);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create((Value)Value.doubleValue((double)this.getMean()), (Timestamp)timestamp);
        }

        double getMean() {
            return this.count == 0L ? 0.0 : this.sum / (double)this.count;
        }

        long getCount() {
            return this.count;
        }

        @VisibleForTesting
        double getSum() {
            return this.sum;
        }
    }

    static final class MutableCount
    extends MutableAggregation {
        private long count = 0L;

        private MutableCount() {
        }

        static MutableCount create() {
            return new MutableCount();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            ++this.count;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableCount), (Object)"MutableCount expected.");
            this.count += Math.round(fraction * (double)((MutableCount)other).getCount());
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.CountData.create((long)this.count);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create((Value)Value.longValue((long)this.count), (Timestamp)timestamp);
        }

        long getCount() {
            return this.count;
        }
    }

    static final class MutableSumLong
    extends MutableSumDouble {
        private MutableSumLong() {
        }

        static MutableSumLong create() {
            return new MutableSumLong();
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.SumDataLong.create((long)Math.round(this.getSum()));
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create((Value)Value.longValue((long)Math.round(this.getSum())), (Timestamp)timestamp);
        }
    }

    static class MutableSumDouble
    extends MutableAggregation {
        private double sum = 0.0;

        private MutableSumDouble() {
        }

        static MutableSumDouble create() {
            return new MutableSumDouble();
        }

        @Override
        void add(double value, Map<String, AttachmentValue> attachments, Timestamp timestamp) {
            this.sum += value;
        }

        @Override
        void combine(MutableAggregation other, double fraction) {
            Preconditions.checkArgument((boolean)(other instanceof MutableSumDouble), (Object)"MutableSumDouble expected.");
            this.sum += fraction * ((MutableSumDouble)other).sum;
        }

        @Override
        AggregationData toAggregationData() {
            return AggregationData.SumDataDouble.create((double)this.sum);
        }

        @Override
        Point toPoint(Timestamp timestamp) {
            return Point.create((Value)Value.doubleValue((double)this.sum), (Timestamp)timestamp);
        }

        @VisibleForTesting
        double getSum() {
            return this.sum;
        }
    }
}

