/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.BiPredicate;

public final class InternalNetServerAttributesExtractor<REQUEST> {
    private final NetServerAttributesGetter<REQUEST> getter;
    private final BiPredicate<Integer, REQUEST> captureHostPortCondition;
    private final FallbackNamePortGetter<REQUEST> fallbackNamePortGetter;

    public InternalNetServerAttributesExtractor(NetServerAttributesGetter<REQUEST> getter, BiPredicate<Integer, REQUEST> captureHostPortCondition, FallbackNamePortGetter<REQUEST> fallbackNamePortGetter) {
        this.getter = getter;
        this.captureHostPortCondition = captureHostPortCondition;
        this.fallbackNamePortGetter = fallbackNamePortGetter;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String sockFamily;
        String sockHostAddr;
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_TRANSPORT, (Object)this.getter.transport(request));
        boolean setSockFamily = false;
        String sockPeerAddr = this.getter.sockPeerAddr(request);
        if (sockPeerAddr != null) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)sockPeerAddr);
            Integer sockPeerPort = this.getter.sockPeerPort(request);
            if (sockPeerPort != null && sockPeerPort > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_PORT, (Object)sockPeerPort);
            }
        }
        String hostName = this.extractHostName(request);
        Integer hostPort = this.extractHostPort(request);
        if (hostName != null) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_HOST_NAME, (Object)hostName);
            if (hostPort != null && hostPort > 0 && this.captureHostPortCondition.test(hostPort, request)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_HOST_PORT, (Object)hostPort);
            }
        }
        if ((sockHostAddr = this.getter.sockHostAddr(request)) != null && !sockHostAddr.equals(hostName)) {
            setSockFamily = true;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_HOST_ADDR, (Object)sockHostAddr);
            Integer sockHostPort = this.getter.sockHostPort(request);
            if (sockHostPort != null && sockHostPort > 0 && !sockHostPort.equals(hostPort)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_HOST_PORT, (Object)sockHostPort);
            }
        }
        if (setSockFamily && (sockFamily = this.getter.sockFamily(request)) != null && !"inet".equals(sockFamily)) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_FAMILY, (Object)sockFamily);
        }
    }

    private String extractHostName(REQUEST request) {
        String peerName = this.getter.hostName(request);
        if (peerName == null) {
            peerName = this.fallbackNamePortGetter.name(request);
        }
        return peerName;
    }

    private Integer extractHostPort(REQUEST request) {
        Integer peerPort = this.getter.hostPort(request);
        if (peerPort == null) {
            peerPort = this.fallbackNamePortGetter.port(request);
        }
        return peerPort;
    }
}

