/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jasperreports.deployment;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkiverse.jasperreports.JasperReportsBeanProducer;
import io.quarkiverse.jasperreports.JasperReportsRecorder;
import io.quarkiverse.jasperreports.config.ReportBuildTimeConfig;
import io.quarkiverse.jasperreports.deployment.AbstractJandexProcessor;
import io.quarkiverse.jasperreports.deployment.item.CompiledReportFileBuildItem;
import io.quarkiverse.jasperreports.deployment.item.ReportFileBuildItem;
import io.quarkiverse.jasperreports.deployment.item.ReportRootBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.logging.Log;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.sf.jasperreports.compilers.ReportExpressionEvaluationData;
import net.sf.jasperreports.components.ComponentsExtensionsRegistryFactory;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElement;
import net.sf.jasperreports.components.iconlabel.IconLabelElement;
import net.sf.jasperreports.components.list.UnusedSpaceImageRenderer;
import net.sf.jasperreports.components.util.AbstractFieldComparator;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.data.xmla.XmlaDataAdapterImpl;
import net.sf.jasperreports.dataadapters.AbstractDataAdapter;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.base.ElementStore;
import net.sf.jasperreports.engine.base.ElementsBlock;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.DefaultExporterFilterFactory;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fonts.AwtFontManager;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.part.DefaultPartComponentsBundle;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.type.ColorEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterFactory;
import net.sf.jasperreports.engine.xml.ReportLoader;
import net.sf.jasperreports.export.CsvExporterConfiguration;
import net.sf.jasperreports.extensions.DefaultExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.functions.FunctionSupport;
import net.sf.jasperreports.functions.standard.MathFunctions;
import net.sf.jasperreports.governors.GovernorExtensionsRegistryFactory;
import net.sf.jasperreports.jackson.util.JacksonUtil;
import net.sf.jasperreports.parts.PartComponentsExtensionsRegistryFactory;
import net.sf.jasperreports.pdf.PdfExporterConfiguration;
import net.sf.jasperreports.pdf.classic.ClassicPdfProducerFactory;
import net.sf.jasperreports.pdf.type.PdfVersionEnum;
import net.sf.jasperreports.poi.query.PoiQueryExecuterFactoryBundle;
import net.sf.jasperreports.renderers.AbstractSvgDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.util.SvgFontProcessor;
import net.sf.jasperreports.repo.DefaultRepositoryExtensionsRegistryFactory;
import net.sf.jasperreports.util.JsonLoader;
import org.apache.commons.lang3.StringUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class JasperReportsProcessor
extends AbstractJandexProcessor {
    private static final String FEATURE = "jasperreports";
    private static final String EXTENSIONS_FILE = "jasperreports_extension.properties";
    private static final DotName JSON_DESERIALIZE = DotName.createSimple((String)JsonDeserialize.class.getName());

    JasperReportsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={IsProduction.class})
    void uberJarFiles(BuildProducer<GeneratedResourceBuildItem> generatedResourcesProducer, BuildProducer<UberJarMergedResourceBuildItem> uberJarMergedProducer, PackageConfig packageConfig) {
        if (packageConfig.jar().type() == PackageConfig.JarConfig.JarType.UBER_JAR) {
            JasperReportsProcessor.mergeAndGenerateJson("properties-metadata.json", generatedResourcesProducer);
        }
        uberJarMergedProducer.produce((BuildItem)new UberJarMergedResourceBuildItem(EXTENSIONS_FILE));
        uberJarMergedProducer.produce((BuildItem)new UberJarMergedResourceBuildItem("metadata_messages-defaults.properties"));
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", FEATURE));
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", "jasperreports-data-adapters"));
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", "jasperreports-excel-poi"));
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", "jasperreports-functions"));
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", "jasperreports-jdt"));
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", "jasperreports-json"));
        index.produce((BuildItem)new IndexDependencyBuildItem("net.sf.jasperreports", "jasperreports-pdf"));
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(this.collectImplementors(combinedIndex, FunctionSupport.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRDataSource.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRDataSourceProvider.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRTemplate.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRVisitor.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRCompiler.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRQueryExecuter.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, QueryExecuterFactory.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, JRXPathExecuterFactory.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, ReportLoader.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, ExtensionsRegistry.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, ExtensionsRegistryFactory.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, AbstractDataAdapter.class.getName()));
        classNames.addAll(this.collectSubclasses(combinedIndex, JRAbstractExporter.class.getName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ReportExpressionEvaluationData.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ComponentsExtensionsRegistryFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, XmlaDataAdapterImpl.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, JasperReport.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ElementStore.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, JRDesignQuery.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, DefaultExporterFilterFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ExporterNature.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, JRFillVariable.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, SimpleFontFace.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, DefaultPartComponentsBundle.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ColorEnum.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ImageUtil.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, JRXPathExecuter.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ReportLoader.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, CsvExporterConfiguration.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, DefaultExtensionsRegistryFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, MathFunctions.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, GovernorExtensionsRegistryFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, JacksonUtil.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, PartComponentsExtensionsRegistryFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, AbstractSvgDataToGraphics2DRenderer.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, SvgFontProcessor.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, DefaultRepositoryExtensionsRegistryFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, JsonLoader.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, ClassicPdfProducerFactory.class.getPackageName()));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, PdfVersionEnum.class.getPackageName()));
        classNames.add("java.util.Collections$CheckedCollection");
        classNames.add("java.util.Collections$CheckedList");
        classNames.add("java.util.Collections$CheckedMap");
        classNames.add("java.util.Collections$CheckedQueue");
        classNames.add("java.util.Collections$CheckedSet");
        classNames.add("java.util.Collections$SynchronizedCollection");
        classNames.add("java.util.Collections$SynchronizedList");
        classNames.add("java.util.Collections$SynchronizedMap");
        classNames.add("java.util.Collections$SynchronizedNavigableMap");
        classNames.add("java.util.Collections$SynchronizedRandomAccessList");
        classNames.add("java.util.Collections$SynchronizedSortedMap");
        classNames.add(Byte.TYPE.getName());
        classNames.add(byte[].class.getName());
        classNames.add(Color.class.getName());
        classNames.add(ColorSpace.class.getName());
        classNames.add(Serializable.class.getName());
        classNames.add(Boolean.class.getName());
        classNames.add(Byte.class.getName());
        classNames.add(Byte.class.getName());
        classNames.add(Character.class.getName());
        classNames.add(Double.class.getName());
        classNames.add(Enum.class.getName());
        classNames.add(Float.class.getName());
        classNames.add(Integer.class.getName());
        classNames.add(Iterable.class.getName());
        classNames.add(Long.class.getName());
        classNames.add(Number.class.getName());
        classNames.add(Object.class.getName());
        classNames.add(Short.class.getName());
        classNames.add(String.class.getName());
        classNames.add(StringBuilder.class.getName());
        classNames.add(BigDecimal.class.getName());
        classNames.add(AbstractList.class.getName());
        classNames.add(AbstractMap.class.getName());
        classNames.add(ArrayList.class.getName());
        classNames.add(Calendar.class.getName());
        classNames.add(Collections.class.getName());
        classNames.add(Date.class.getName());
        classNames.add(GregorianCalendar.class.getName());
        classNames.add(HashMap.class.getName());
        classNames.add(HashSet.class.getName());
        classNames.add(Hashtable.class.getName());
        classNames.add(LinkedHashMap.class.getName());
        classNames.add(LinkedHashSet.class.getName());
        classNames.add(LinkedList.class.getName());
        classNames.add(List.class.getName());
        classNames.add(Map.class.getName());
        classNames.add(Set.class.getName());
        classNames.add(TreeMap.class.getName());
        classNames.add(TreeSet.class.getName());
        classNames.add(UUID.class.getName());
        classNames.add(Vector.class.getName());
        classNames.addAll(this.collectImplementors(combinedIndex, TemporalAccessor.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, Collection.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, Map.Entry.class.getName()));
        TreeSet uniqueClasses = new TreeSet(classNames);
        Log.debugf((String)"Jasper Reflection: %s", uniqueClasses);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])uniqueClasses.toArray(new String[0])).constructors().methods().fields().serialization().build());
    }

    @BuildStep
    void runtimeInitializedClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<RuntimeInitializedPackageBuildItem> runtimeInitializedPackages) {
        List<String> classes = this.collectImplementors(combinedIndex, ExtensionsRegistryFactory.class.getName());
        classes.addAll(Stream.of("javax.swing", "javax.swing.plaf.metal", "javax.swing.text.html", "javax.swing.text.rtf", "sun.datatransfer", "sun.swing", "sun.lwawt.LWWindowPeer", HeaderToolbarElement.class.getPackageName(), IconLabelElement.class.getPackageName(), UnusedSpaceImageRenderer.class.getName(), AbstractFieldComparator.class.getPackageName(), MeasureDefinition.class.getPackageName(), SimpleReportContext.class.getPackageName(), ElementsBlock.class.getPackageName(), ReportConverter.class.getName(), AbstractTextRenderer.class.getPackageName(), JRFillSubreport.class.getPackageName(), AwtFontManager.class.getPackageName(), ColorEnum.class.getPackageName(), JRQueryExecuterUtils.class.getPackageName(), PoiQueryExecuterFactoryBundle.class.getName()).toList());
        Log.debugf((String)"Jasper Runtime: %s", classes);
        classes.stream().map(RuntimeInitializedPackageBuildItem::new).forEach(arg_0 -> runtimeInitializedPackages.produce(arg_0));
    }

    @BuildStep
    void registerResourceBuildItems(BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"jasperreports.properties", EXTENSIONS_FILE, "default.jasperreports.properties", "jasperreports_messages.properties", "metadata_messages.properties", "metadata_messages-defaults.properties", "properties-metadata.json"}));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("jasperreports_messages"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("metadata_messages"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("metadata_messages-defaults"));
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("net/sf/jasperreports/engine/export/ooxml/docx/**");
        builder.includeGlob("net/sf/jasperreports/engine/export/ooxml/pptx/**");
        builder.includeGlob("net/sf/jasperreports/engine/export/ooxml/xlsx/**");
        builder.includeGlob("net/sf/jasperreports/fonts/icons/**");
        builder.includeGlob("net/sf/jasperreports/engine/images/**");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
    }

    @BuildStep
    void registerReports(BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns) {
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("**/*.jrxml");
        builder.includeGlob("**/*.jasper");
        builder.includeGlob("**/*.jrtx");
        builder.includeGlob("**/*.jrdax");
        builder.includeGlob("*.jrxml");
        builder.includeGlob("*.jasper");
        builder.includeGlob("*.jrtx");
        builder.includeGlob("*.jrdax");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
    }

    @BuildStep
    void registerCompiledReports(BuildProducer<GeneratedClassBuildItem> additionalClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, List<CompiledReportFileBuildItem> compiledReports) {
        for (CompiledReportFileBuildItem reportFile : compiledReports) {
            Log.debugf((String)"Jasper compiled report: %s", (Object)reportFile.getPath());
            try {
                Map crossTabs;
                JRDataset[] datasets;
                String jasperFilePath = reportFile.getPath().toFile().getAbsolutePath();
                JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getLocationInputStream((String)jasperFilePath));
                JRReportCompileData compileData = (JRReportCompileData)report.getCompileData();
                ArrayList<ReportExpressionEvaluationData> datasetClasses = new ArrayList<ReportExpressionEvaluationData>();
                ReportExpressionEvaluationData mainData = (ReportExpressionEvaluationData)compileData.getMainDatasetCompileData();
                if (mainData != null) {
                    datasetClasses.add((ReportExpressionEvaluationData)compileData.getMainDatasetCompileData());
                }
                if ((datasets = report.getDatasets()) != null) {
                    for (JRDataset dataset : datasets) {
                        ReportExpressionEvaluationData reportData = (ReportExpressionEvaluationData)compileData.getDatasetCompileData(dataset);
                        datasetClasses.add(reportData);
                    }
                }
                if ((crossTabs = compileData.getCrosstabsCompileData()) != null) {
                    for (Serializable value : crossTabs.values()) {
                        if (!(value instanceof ReportExpressionEvaluationData)) continue;
                        ReportExpressionEvaluationData reportData = (ReportExpressionEvaluationData)value;
                        datasetClasses.add(reportData);
                    }
                }
                LinkedHashSet<String> uniqueReportClassNames = new LinkedHashSet<String>(datasetClasses.size());
                for (ReportExpressionEvaluationData reportData : datasetClasses) {
                    String reportDataClass = reportData.getCompileName();
                    if (!StringUtils.isNotBlank((CharSequence)reportDataClass)) continue;
                    if (uniqueReportClassNames.contains(reportDataClass)) {
                        throw new IllegalStateException("Duplicate report class found: " + reportDataClass + " Please review all reports for duplicate names.");
                    }
                    uniqueReportClassNames.add(reportDataClass);
                    byte[] bytes = (byte[])reportData.getCompileData();
                    Log.debugf((String)"JasperReport Data Class: %s Size: %d", (Object)reportDataClass, (Object)bytes.length);
                    reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{reportDataClass}).constructors().methods().serialization().build());
                    additionalClasses.produce((BuildItem)new GeneratedClassBuildItem(true, reportDataClass, bytes));
                }
            }
            catch (JRException e) {
                Log.error((Object)"Error loading JasperReport file class.", (Throwable)e);
            }
        }
    }

    @BuildStep
    void registerJasperReportsProxies(CombinedIndexBuildItem combinedIndex, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions) {
        ArrayList<String> classes = new ArrayList<String>(this.collectInterfacesInPackage(combinedIndex, CsvExporterConfiguration.class.getPackageName()));
        classes.addAll(this.collectInterfacesInPackage(combinedIndex, PdfExporterConfiguration.class.getPackageName()));
        for (String proxyClassName : classes) {
            proxyDefinitions.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{proxyClassName}));
        }
    }

    @BuildStep
    void registerFonts(BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns) {
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("**/fonts/dejavu/**");
        builder.includeGlob("fonts/**");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
    }

    @BuildStep
    void ignoreJacksonDeserialize(CombinedIndexBuildItem combinedIndex, BuildProducer<IgnoreJsonDeserializeClassBuildItem> ignoredJsonDeserializationClasses) {
        IndexView index = combinedIndex.getIndex();
        for (AnnotationInstance deserializeInstance : index.getAnnotations(JSON_DESERIALIZE)) {
            DotName dotName;
            AnnotationTarget annotationTarget = deserializeInstance.target();
            if (!AnnotationTarget.Kind.CLASS.equals((Object)annotationTarget.kind()) || !(dotName = annotationTarget.asClass().name()).packagePrefix().startsWith("net.sf.jasperreports")) continue;
            Log.debugf((String)"Ignore @JsonDeserialize: %s", (Object)dotName);
            ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(dotName));
        }
    }

    @BuildStep
    ReportRootBuildItem defaultReportRoot(ReportBuildTimeConfig config) {
        if (config.build().enable()) {
            return new ReportRootBuildItem(config.build().source());
        }
        return new ReportRootBuildItem(Path.of("src/main/jasperreports", new String[0]));
    }

    @BuildStep
    void collectReportFiles(List<ReportRootBuildItem> reportRoots, final BuildProducer<ReportFileBuildItem> reportFilesProducer, final BuildProducer<CompiledReportFileBuildItem> compiledReportFileProducer, OutputTargetBuildItem outputTarget) {
        final AtomicInteger count = new AtomicInteger(0);
        for (ReportRootBuildItem reportRoot : reportRoots) {
            Path startDir = null;
            if (Files.exists(reportRoot.getOriginalPath(), new LinkOption[0])) {
                Log.debugf((String)"JasperReport Source Directory: %s", (Object)reportRoot.getOriginalPath());
                startDir = reportRoot.getOriginalPath();
            }
            if (startDir == null) {
                Path projectRoot = JasperReportsProcessor.findProjectRoot(outputTarget.getOutputDirectory());
                if (projectRoot == null) {
                    Log.warnf((String)"JasperReport Source Directory does not exist!", (Object[])new Object[0]);
                    continue;
                }
                startDir = projectRoot.resolve(Paths.get(reportRoot.getPath(), new String[0])).normalize();
                if (!Files.exists(startDir, new LinkOption[0])) {
                    Log.warnf((String)"JasperReport Source Directory: %s does not exist!", (Object)startDir);
                    continue;
                }
            }
            try {
                Files.walkFileTree(startDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        for (String ext : ReportFileBuildItem.EXTENSIONS) {
                            String filePath = file.toString();
                            if (!filePath.endsWith(ext)) continue;
                            count.incrementAndGet();
                            reportFilesProducer.produce((BuildItem)new ReportFileBuildItem(file));
                            if (!filePath.endsWith("jasper")) break;
                            compiledReportFileProducer.produce((BuildItem)new CompiledReportFileBuildItem(file));
                            break;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Log.error((Object)"Error looking for JasperReport files.", (Throwable)e);
            }
        }
        Log.debugf((String)"Collected %s report file(s)", (int)count.get());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void watchReportFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, List<ReportFileBuildItem> reportFiles) {
        reportFiles.forEach(file -> {
            if (Files.isRegularFile(file.getPath(), new LinkOption[0])) {
                Log.debugf((String)"Watching report file %s", (Object)file);
                watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(file.getPath().toString()));
            }
        });
    }

    @BuildStep
    void compileReports(ReportBuildTimeConfig config, List<ReportFileBuildItem> reportFiles, BuildProducer<CompiledReportFileBuildItem> compiledReportFileProducer, OutputTargetBuildItem outputTarget) {
        if (!config.build().enable()) {
            Log.debug((Object)"Automatic report compilation disabled");
            return;
        }
        Log.debugf((String)"Found %s report(s) to compile", (int)reportFiles.size());
        try {
            Path outputDirectoryPath = Path.of(outputTarget.getOutputDirectory().toString(), "classes", config.build().destination().toString());
            if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
                Files.createDirectories(outputDirectoryPath, new FileAttribute[0]);
            }
            for (ReportFileBuildItem item : reportFiles) {
                String outputFile;
                Path outputFilePath;
                if (item.getFileName().endsWith(".jrxml")) {
                    outputFilePath = Path.of(outputDirectoryPath.toString(), item.getFileName().replace(".jrxml", ".jasper"));
                    outputFile = outputFilePath.toString();
                    try {
                        if (JasperReportsProcessor.shouldUpdateFile(item.getPath(), outputFilePath)) {
                            Log.infof((String)"Compiling %s into %s", (Object)item.getPath().toString(), (Object)outputFile);
                            try (InputStream inputStream = JRLoader.getLocationInputStream((String)item.getPath().toAbsolutePath().toString());
                                 ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                                JasperCompileManager.compileReportToStream((InputStream)inputStream, (OutputStream)outputStream);
                                Log.debugf((String)"Compiled size is %s", (int)outputStream.size());
                                try (FileOutputStream fos = new FileOutputStream(outputFile);){
                                    outputStream.writeTo(fos);
                                }
                            }
                        }
                        compiledReportFileProducer.produce((BuildItem)new CompiledReportFileBuildItem(outputFilePath));
                    }
                    catch (IOException | JRException ex) {
                        Log.fatalf((String)"Error while compiling report %s: %s", (Object)item.getPath(), (Object)ex.getMessage());
                        Log.debug((Object)ex);
                    }
                    continue;
                }
                if (!item.getFileName().endsWith(".jrtx")) continue;
                outputFilePath = Path.of(outputDirectoryPath.toString(), item.getFileName());
                outputFile = outputFilePath.toString();
                try {
                    if (!JasperReportsProcessor.shouldUpdateFile(item.getPath(), outputFilePath)) continue;
                    Log.infof((String)"Copying %s into %s", (Object)item.getPath().toString(), (Object)outputFile);
                    try (FileOutputStream fos = new FileOutputStream(outputFile);){
                        Files.copy(item.getPath(), fos);
                    }
                }
                catch (IOException ex) {
                    Log.fatalf((String)"I/O Error while copying styles: %s", (Object)ex.getMessage());
                    Log.debug((Object)ex);
                }
            }
        }
        catch (IOException ex) {
            Log.fatalf((String)"I/O Error while compiling reports: %s", (Object)ex.getMessage());
            Log.debug((Object)ex);
        }
    }

    @BuildStep
    AdditionalBeanBuildItem registerBeanProducer() {
        return AdditionalBeanBuildItem.unremovableOf(JasperReportsBeanProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void initializeBeanProducer(JasperReportsRecorder recorder, BeanContainerBuildItem beanContainer, ReportBuildTimeConfig config) {
        recorder.initProducer(beanContainer.getValue(), config);
    }

    @BuildStep
    SystemPropertyBuildItem sysPropHeadless(NativeConfig nativeConfig) {
        if (nativeConfig.enabled()) {
            return new SystemPropertyBuildItem("java.awt.headless", "true");
        }
        return null;
    }

    private static void mergeAndGenerateJson(String filename, BuildProducer<GeneratedResourceBuildItem> generatedResourcesProducer) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            ArrayList<URL> resources = Collections.list(Thread.currentThread().getContextClassLoader().getResources(filename));
            for (URL resource : resources) {
                Log.debugf((String)"Appending JSON: %s", (Object)resource);
                InputStream is = resource.openStream();
                try {
                    JsonReader reader = Json.createReader((InputStream)is);
                    try {
                        JsonObject json = reader.readObject();
                        arrayBuilder.add((JsonValue)json);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            Map config = Collections.emptyMap();
            JsonWriterFactory writerFactory = Json.createWriterFactory(config);
            try (JsonWriter writer = writerFactory.createWriter((OutputStream)outputStream);){
                writer.writeArray(arrayBuilder.build());
            }
            Log.warnf((String)"JSON Combined: %s", (Object)filename);
            generatedResourcesProducer.produce((BuildItem)new GeneratedResourceBuildItem(filename, outputStream.toByteArray()));
        }
        catch (IOException ex) {
            Log.errorf((String)"Unexpected error combining %s", (Object)filename, (Object)ex);
        }
    }

    private static boolean shouldUpdateFile(Path inputFilePath, Path outputFilePath) throws IOException {
        if (Files.exists(outputFilePath, new LinkOption[0])) {
            FileTime inputFileLastModifiedTime = Files.getLastModifiedTime(inputFilePath, new LinkOption[0]);
            FileTime outputFileLastModifiedTime = Files.getLastModifiedTime(outputFilePath, new LinkOption[0]);
            if (outputFileLastModifiedTime.compareTo(inputFileLastModifiedTime) >= 0) {
                Log.debugf((String)"Skipping update, output file %s is up to date.", (Object)outputFilePath.toString());
                return false;
            }
        }
        return true;
    }

    private static Path findProjectRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            if (Files.exists(currentPath.resolve(Paths.get("src", "main")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.properties")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yaml")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yml")), new LinkOption[0])) {
                return currentPath.normalize();
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }
}

