/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jasperreports.deployment.item;

import io.quarkus.builder.item.MultiBuildItem;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractReportFileBuildItem
extends MultiBuildItem {
    public static final List<String> EXTENSIONS = List.of(".jrxml", ".jasper", ".jrtx", ".jrdax");
    private final Path path;

    public AbstractReportFileBuildItem(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }

    public String getParent() {
        return this.path.getParent().toString();
    }

    public String getType() {
        String extension;
        return switch (extension = FilenameUtils.getExtension((String)this.path.getFileName().toString()).toLowerCase(Locale.ROOT)) {
            case "jasper" -> "COMPILED";
            case "jrxml" -> "REPORT";
            case "jrtx" -> "STYLES";
            case "jrdax" -> "ADAPTER";
            default -> "???";
        };
    }

    public String toString() {
        return new StringJoiner(", ", AbstractReportFileBuildItem.class.getSimpleName() + "[", "]").add("path=" + String.valueOf(this.path)).toString();
    }
}

