/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jasperreports.repository;

import io.quarkus.runtime.util.ClassPathUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.repo.FileRepositoryPersistenceServiceFactory;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceServiceFactory;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.jboss.logging.Logger;

public class ReadOnlyStreamingService
implements StreamRepositoryService {
    private static final Logger LOG = Logger.getLogger(ReadOnlyStreamingService.class);
    private final JasperReportsContext context = new SimpleJasperReportsContext();
    private final Path destinationPath;

    public ReadOnlyStreamingService(Path destinationPath) {
        this.destinationPath = destinationPath;
        SimpleJasperReportsContext simpleContext = (SimpleJasperReportsContext)this.context;
        simpleContext.setExtensions(RepositoryService.class, Collections.singletonList(this));
        simpleContext.setExtensions(PersistenceServiceFactory.class, Collections.singletonList(FileRepositoryPersistenceServiceFactory.getInstance()));
    }

    public JasperReportsContext getContext() {
        return this.context;
    }

    public InputStream getInputStream(String uri) {
        LOG.debugf("Loading getInputStream %s", (Object)uri);
        String logType = null;
        String filePath = null;
        if (uri.endsWith("jasper") || uri.endsWith("jrtx")) {
            logType = uri.endsWith("jasper") ? "report" : "style";
            filePath = ClassPathUtils.toResourceName((Path)Path.of(this.destinationPath.toString(), uri));
        } else if (uri.endsWith("jrdax")) {
            logType = "data adapter";
        }
        if (logType != null) {
            try {
                InputStream is = JRLoader.getLocationInputStream(filePath);
                LOG.debugf("Loading %s file %s %s", (Object)logType, (Object)filePath, (Object)is);
                return is;
            }
            catch (JRException ex) {
                LOG.warnf("Failed to load %s - %s", (Object)logType, (Object)ex.getMessage());
                LOG.debug((Object)ex);
            }
        }
        return null;
    }

    public OutputStream getOutputStream(String uri) {
        LOG.warnf("Read-Only repository called getOutputStream: %s", (Object)uri);
        throw new IllegalStateException("This repository is read only");
    }

    public Resource getResource(String uri) {
        LOG.warnf("Read-Only repository called getResource: %s", (Object)uri);
        throw new IllegalStateException("Can only return an InputStream");
    }

    public void saveResource(String uri, Resource resource) {
        LOG.warnf("Read-Only repository called saveResource: %s", (Object)uri);
        throw new IllegalStateException("This repository is read only");
    }

    public <T extends Resource> T getResource(String uri, Class<T> resourceType) {
        LOG.debugf("getResource %s type %s", (Object)uri, resourceType);
        PersistenceService persistenceService = PersistenceUtil.getInstance((JasperReportsContext)this.context).getService(FileRepositoryService.class, resourceType);
        if (null != persistenceService) {
            return (T)persistenceService.load((RepositoryContext)SimpleRepositoryContext.of((JasperReportsContext)this.context), uri, (RepositoryService)this);
        }
        return null;
    }
}

