/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.LambdaCreator;
import io.quarkus.gizmo2.impl.MethodCreatorImpl;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.function.Consumer;

public final class LambdaAsMethodCreatorImpl
implements LambdaCreator {
    private final ClassDesc functionalInterfaceDesc;
    private final MethodTypeDesc samDesc;
    private final MethodCreatorImpl samCreator;
    private final List<Expr> captures;
    private boolean parametersDefined;

    public LambdaAsMethodCreatorImpl(ClassDesc functionalInterfaceDesc, MethodTypeDesc samDesc, MethodCreatorImpl samCreator, List<Expr> captures) {
        this.functionalInterfaceDesc = functionalInterfaceDesc;
        this.samDesc = samDesc;
        this.samCreator = samCreator;
        this.captures = captures;
    }

    @Override
    public ClassDesc type() {
        return this.functionalInterfaceDesc;
    }

    @Override
    public ParamVar parameter(String name, int position) {
        this.parametersDefined = true;
        return this.samCreator.parameter(name, this.captures.size() + position, this.samDesc.parameterType(position));
    }

    @Override
    public void body(Consumer<BlockCreator> builder) {
        this.samCreator.body(builder);
    }

    @Override
    public Var capture(String name, Expr value) {
        if (this.parametersDefined) {
            throw new IllegalStateException("All captures must be defined before parameters are defined");
        }
        this.captures.add(value);
        if (value.hasGenericType()) {
            return this.samCreator.parameter(name, value.genericType());
        }
        return this.samCreator.parameter(name, value.type());
    }
}

