/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartSpec;
import io.quarkus.devtools.codestarts.NestedMaps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CodestartData {
    private CodestartData() {
    }

    public static Optional<String> getBuildtool(Map<String, Object> data) {
        return NestedMaps.getValue(data, "codestart-project.buildtool.name");
    }

    static Map<String, Object> buildCodestartData(Codestart codestart, String languageName, Map<String, Object> data) {
        Optional<Map> value = NestedMaps.getValue(data, codestart.getName());
        HashMap<String, Object> codestartData = new HashMap<String, Object>();
        codestartData.putAll(data);
        NestedMaps.deepMerge(codestartData, codestart.getLocalData(languageName));
        value.ifPresent(map -> NestedMaps.deepMerge(codestartData, map));
        return codestartData;
    }

    public static Map<String, Object> buildCodestartProjectData(Collection<Codestart> baseCodestarts, Collection<Codestart> extraCodestarts) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        baseCodestarts.forEach(c -> data.put("codestart-project." + c.getSpec().getType().toString().toLowerCase() + ".name", c.getName()));
        data.put("codestart-project.codestarts", extraCodestarts.stream().map(Codestart::getName).collect(Collectors.toList()));
        return NestedMaps.unflatten(data);
    }

    static Map<String, Object> buildDependenciesData(Stream<Codestart> codestartsStream, String languageName, Collection<AppArtifactKey> extensions) {
        HashMap depsData = new HashMap();
        Set extensionsAsDeps = extensions.stream().map(k -> k.getGroupId() + ":" + k.getArtifactId()).map(CodestartSpec.CodestartDep::new).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet dependencies = new LinkedHashSet(extensionsAsDeps);
        LinkedHashSet testDependencies = new LinkedHashSet();
        codestartsStream.flatMap(s -> Stream.of(s.getBaseLanguageSpec(), s.getLanguageSpec(languageName))).forEach(d -> {
            dependencies.addAll(d.getDependencies());
            testDependencies.addAll(d.getTestDependencies());
        });
        depsData.put("dependencies", dependencies);
        depsData.put("test-dependencies", testDependencies);
        return Collections.unmodifiableMap(depsData);
    }
}

