/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.codestarts.CodestartInput;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CodestartInputBuilder {
    CodestartResourceLoader resourceLoader;
    Map<AppArtifactKey, String> extensionCodestartMapping;
    Collection<AppArtifactKey> dependencies = new ArrayList<AppArtifactKey>();
    Collection<String> codestarts = new ArrayList<String>();
    Map<String, Object> data = new HashMap<String, Object>();

    CodestartInputBuilder(CodestartResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public CodestartInputBuilder addDependencies(Collection<AppArtifactKey> dependencies) {
        this.dependencies.addAll(dependencies);
        return this;
    }

    public CodestartInputBuilder addDependency(AppArtifactKey dependency) {
        return this.addDependencies(Collections.singletonList(dependency));
    }

    public CodestartInputBuilder addCodestarts(Collection<String> codestarts) {
        this.codestarts.addAll(codestarts);
        return this;
    }

    public CodestartInputBuilder addData(Map<String, Object> data) {
        this.data.putAll(data);
        return this;
    }

    public CodestartInputBuilder addCodestart(String name) {
        this.codestarts.add(name);
        return this;
    }

    public CodestartInputBuilder putData(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public CodestartInput build() {
        return new CodestartInput(this);
    }
}

