/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.AppendCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.DefaultCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.ExecutableFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.FailOnDuplicateCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.ForbiddenCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.NativeTestDirResolveCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.ReplaceCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.SmartConfigMergeCodestartFileStrategyHandler;
import io.quarkus.devtools.codestarts.strategy.SmartPomMergeCodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface CodestartFileStrategyHandler {
    public static final DefaultCodestartFileStrategyHandler DEFAULT_STRATEGY = new FailOnDuplicateCodestartFileStrategyHandler();
    public static final Map<String, CodestartFileStrategyHandler> BY_NAME = Stream.of(DEFAULT_STRATEGY, new AppendCodestartFileStrategyHandler(), new ExecutableFileStrategyHandler(), new ReplaceCodestartFileStrategyHandler(), new ForbiddenCodestartFileStrategyHandler(), new SmartConfigMergeCodestartFileStrategyHandler(), new SmartPomMergeCodestartFileStrategyHandler(), new NativeTestDirResolveCodestartFileStrategyHandler()).collect(Collectors.toMap(CodestartFileStrategyHandler::name, Function.identity()));

    public String name();

    public void process(Path var1, String var2, List<CodestartFile> var3, Map<String, Object> var4) throws IOException;

    default public void checkNotEmptyCodestartFiles(List<CodestartFile> codestartFiles) {
        if (codestartFiles == null || codestartFiles.isEmpty()) {
            throw new CodestartDefinitionException("codestartFiles must not be null or empty");
        }
    }

    default public void checkTargetDoesNotExist(Path targetPath) {
        if (Files.exists(targetPath, new LinkOption[0])) {
            throw new CodestartDefinitionException("Target file already exists: " + targetPath.toString());
        }
    }

    default public void createDirectories(Path targetPath) throws IOException {
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
    }
}

