/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.CodestartDefinitionException;
import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.DefaultCodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;

final class FailOnDuplicateCodestartFileStrategyHandler
implements DefaultCodestartFileStrategyHandler {
    static final String NAME = "fail-on-duplicate";

    FailOnDuplicateCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<CodestartFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        if (codestartFiles.size() > 1 || Files.exists(targetPath, new LinkOption[0])) {
            throw new CodestartDefinitionException("Multiple files found for path with 'fail-on-duplicate' FileStrategy: " + relativePath);
        }
        this.createDirectories(targetPath);
        Files.write(targetPath, codestartFiles.get(0).getContent().getBytes(), new OpenOption[0]);
    }

    @Override
    public void copyStaticFile(Path sourcePath, Path targetPath) throws IOException {
        if (Files.exists(targetPath, new LinkOption[0])) {
            throw new CodestartDefinitionException("Multiple files found for path with 'fail-on-duplicate' FileStrategy: " + sourcePath + ":" + targetPath);
        }
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.copy(sourcePath, targetPath, new CopyOption[0]);
    }
}

