/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.oauth2.runtime.auth;

import io.quarkus.elytron.security.oauth2.runtime.auth.ElytronOAuth2CallerPrincipal;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class OAuth2Augmentor
implements SecurityIdentityAugmentor {
    private final String roleClaim;

    public OAuth2Augmentor(String roleClaim) {
        this.roleClaim = roleClaim;
    }

    public int priority() {
        return 0;
    }

    public CompletionStage<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        CompletableFuture<SecurityIdentity> cs = new CompletableFuture<SecurityIdentity>();
        if (identity.getPrincipal() instanceof ElytronOAuth2CallerPrincipal) {
            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder().setPrincipal(identity.getPrincipal()).addAttributes(identity.getAttributes()).addCredentials(identity.getCredentials()).addRoles(identity.getRoles());
            String[] roles = this.extractRoles((ElytronOAuth2CallerPrincipal)identity.getPrincipal());
            if (roles != null) {
                for (String i : roles) {
                    builder.addRole(i);
                }
            }
            cs.complete((SecurityIdentity)builder.build());
        } else {
            cs.complete(identity);
        }
        return cs;
    }

    private String[] extractRoles(ElytronOAuth2CallerPrincipal principal) {
        Object claims = principal.getClaims().get(this.roleClaim);
        if (claims instanceof List) {
            return ((List)claims).toArray(new String[0]);
        }
        String claim = (String)principal.getClaims().get(this.roleClaim);
        if (claim == null) {
            return null;
        }
        return claim.split(" ");
    }
}

