/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.oauth2.runtime.auth;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class OAuth2AuthMechanism
implements HttpAuthenticationMechanism {
    public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String bearerToken;
        String authHeader = context.request().headers().get("Authorization");
        String string = bearerToken = authHeader != null ? authHeader.substring(7) : null;
        if (bearerToken != null) {
            return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest(new TokenCredential(bearerToken, "bearer")));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, "Bearer {token}");
        return CompletableFuture.completedFuture(result);
    }
}

