/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.Mailer;
import io.quarkus.mailer.reactive.ReactiveMailer;
import java.time.Duration;

public class BlockingMailerImpl
implements Mailer {
    private final ReactiveMailer mailer;
    private final Duration timeout;

    BlockingMailerImpl(ReactiveMailer mailer, Duration timeout) {
        this.mailer = mailer;
        this.timeout = timeout;
    }

    @Override
    public void send(Mail ... mails) {
        if (this.timeout == null || this.timeout.isZero()) {
            this.mailer.send(mails).await().indefinitely();
        } else {
            this.mailer.send(mails).await().atMost(this.timeout);
        }
    }
}

